/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.PreferedProducerFind;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.List;

public class CreateAction
extends BaseRunConfigurationAction {
    private static final BaseCreatePolicy CREATE_AND_EDIT = new CreateAndEditPolicy();
    private static final BaseCreatePolicy SELECT = new SelectPolicy();
    private static final BaseCreatePolicy SAVE = new SavePolicy();
    private static final BaseCreatePolicy SELECTED_STABLE = new BaseCreatePolicy(BaseCreatePolicy.ActionType.SELECT){

        @Override
        public void perform(ConfigurationContext context) {
        }

        @Override
        public void update(Presentation presentation, ConfigurationContext context, String actionText) {
            super.update(presentation, context, actionText);
            presentation.setVisible(false);
        }
    };

    public CreateAction() {
        super(ExecutionBundle.message((String)"create.run.configuration.action.name", (Object[])new Object[0]), null, null);
    }

    @Override
    protected void perform(ConfigurationContext context) {
        CreateAction.choosePolicy(context).perform(context);
    }

    @Override
    protected void updatePresentation(Presentation presentation, String actionText, ConfigurationContext context) {
        CreateAction.choosePolicy(context).update(presentation, context, actionText);
    }

    private static BaseCreatePolicy choosePolicy(ConfigurationContext context) {
        RunnerAndConfigurationSettingsImpl configuration = context.findExisting();
        if (configuration == null) {
            return CREATE_AND_EDIT;
        }
        RunManagerEx runManager = context.getRunManager();
        if (runManager.getSelectedConfiguration() != configuration) {
            return SELECT;
        }
        if (runManager.isTemporary(configuration.getConfiguration())) {
            return SAVE;
        }
        return SELECTED_STABLE;
    }

    private static class SavePolicy
    extends BaseCreatePolicy {
        public SavePolicy() {
            super(BaseCreatePolicy.ActionType.SAVE);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettingsImpl settings = context.findExisting();
            if (settings != null) {
                context.getRunManager().makeStable(settings.getConfiguration());
            }
        }

        @Override
        protected void updateIcon(Presentation presentation, ConfigurationContext context) {
            RunnerAndConfigurationSettingsImpl configuration = context.findExisting();
            if (configuration != null) {
                presentation.setIcon(configuration.getType().getIcon());
            } else {
                super.updateIcon(presentation, context);
            }
        }
    }

    private static class CreateAndEditPolicy
    extends CreatePolicy {
        private CreateAndEditPolicy() {
        }

        @Override
        protected void updateText(Presentation presentation, String actionText) {
            presentation.setText(ExecutionBundle.message((String)"create.run.configuration.for.item.action.name", (Object[])new Object[]{actionText}) + "...", false);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettingsImpl configuration = context.getConfiguration();
            if (RunDialog.editConfiguration(context.getProject(), configuration, ExecutionBundle.message((String)"create.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}))) {
                RunManagerImpl runManager = (RunManagerImpl)context.getRunManager();
                runManager.addConfiguration(configuration, runManager.isConfigurationShared(configuration), runManager.getBeforeRunTasks(configuration.getConfiguration()));
                runManager.setActiveConfiguration(configuration);
            }
        }
    }

    private static class CreatePolicy
    extends BaseCreatePolicy {
        public CreatePolicy() {
            super(BaseCreatePolicy.ActionType.CREATE);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunManagerImpl runManager = (RunManagerImpl)context.getRunManager();
            RunnerAndConfigurationSettingsImpl configuration = context.getConfiguration();
            RunnerAndConfigurationSettingsImpl template = runManager.getConfigurationTemplate(configuration.getFactory());
            RunConfiguration templateConfiguration = template.getConfiguration();
            runManager.addConfiguration(configuration, runManager.isConfigurationShared(template), runManager.getBeforeRunTasks(templateConfiguration));
            runManager.setActiveConfiguration(configuration);
        }
    }

    private static class SelectPolicy
    extends BaseCreatePolicy {
        public SelectPolicy() {
            super(BaseCreatePolicy.ActionType.SELECT);
        }

        @Override
        public void perform(ConfigurationContext context) {
            RunnerAndConfigurationSettingsImpl configuration = context.findExisting();
            if (configuration == null) {
                return;
            }
            context.getRunManager().setActiveConfiguration(configuration);
        }

        @Override
        protected void updateIcon(Presentation presentation, ConfigurationContext context) {
            RunnerAndConfigurationSettingsImpl configuration = context.findExisting();
            if (configuration != null) {
                presentation.setIcon(configuration.getType().getIcon());
            } else {
                super.updateIcon(presentation, context);
            }
        }
    }

    private static abstract class BaseCreatePolicy {
        private final ActionType myType;

        public BaseCreatePolicy(ActionType type) {
            this.myType = type;
        }

        public void update(Presentation presentation, ConfigurationContext context, String actionText) {
            this.updateText(presentation, actionText);
            this.updateIcon(presentation, context);
        }

        protected void updateIcon(Presentation presentation, ConfigurationContext context) {
            List<RuntimeConfigurationProducer> producers = PreferedProducerFind.findPreferredProducers(context.getLocation(), context, true);
            if (producers != null && producers.size() == 1) {
                presentation.setIcon(context.getConfiguration().getFactory().getIcon());
            }
        }

        protected void updateText(Presentation presentation, String actionText) {
            presentation.setText(this.generateName(actionText), false);
        }

        private String generateName(String actionText) {
            switch (this.myType) {
                case CREATE: {
                    return ExecutionBundle.message((String)"create.run.configuration.for.item.action.name", (Object[])new Object[]{actionText});
                }
                case SELECT: {
                    return ExecutionBundle.message((String)"select.run.configuration.for.item.action.name", (Object[])new Object[]{actionText});
                }
            }
            return ExecutionBundle.message((String)"save.run.configuration.for.item.action.name", (Object[])new Object[]{actionText});
        }

        public abstract void perform(ConfigurationContext var1);

        public static enum ActionType {
            CREATE,
            SAVE,
            SELECT;

        }
    }
}

