/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.PreferedProducerFind;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseRunConfigurationAction
extends AnAction {
    private static final Icon EDIT_ICON = IconLoader.getIcon((String)"/actions/editSource.png");
    private static final Icon SAVE_ICON = IconLoader.getIcon((String)"/runConfigurations/saveTempConfig.png");
    private Executor myCurrentExecutor;
    private boolean myEditConfiguration;

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        assert (project != null);
        Executor executor = this.getDefaultExecutor();
        assert (executor != null);
        RunListPopup popup = new RunListPopup(project, (ListPopupStep)new ConfigurationListPopupStep(this, project, String.format("%s", executor.getActionName()))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void handleShiftClick(boolean handleFinalChoices, InputEvent inputEvent, RunListPopup popup) {
                try {
                    ChooseRunConfigurationAction.this.myCurrentExecutor = ChooseRunConfigurationAction.this.getAlternateExecutor();
                    popup._handleSelect(handleFinalChoices, inputEvent);
                }
                finally {
                    ChooseRunConfigurationAction.this.myCurrentExecutor = null;
                }
            }
        };
        this.registerActions(popup);
        String adText = this.getAdText(this.getAlternateExecutor());
        if (adText != null) {
            popup.setAdText(adText);
        }
        popup.showCenteredInCurrentWindow(project);
    }

    protected String getAdKey() {
        return "run.configuration.alternate.action.ad";
    }

    protected static boolean canRun(@NotNull Executor executor, RunnerAndConfigurationSettingsImpl settings) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction.canRun must not be null");
        }
        return ExecutionUtil.getRunner(executor.getId(), settings) != null;
    }

    @Nullable
    protected String getAdText(Executor alternateExecutor) {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (alternateExecutor != null && !properties.isTrueValue(this.getAdKey())) {
            return String.format("Hold %s to %s", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("SHIFT")), alternateExecutor.getActionName());
        }
        if (!properties.isTrueValue("run.configuration.edit.ad")) {
            return String.format("Press %s to Edit", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("F4")));
        }
        if (!properties.isTrueValue("run.configuration.delete.ad")) {
            return String.format("Press %s to Delete configuration", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("DELETE")));
        }
        return null;
    }

    private void registerActions(final RunListPopup popup) {
        popup.registerAction("alternateExecutor", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationAction.this.myCurrentExecutor = ChooseRunConfigurationAction.this.getAlternateExecutor();
                ChooseRunConfigurationAction.this.updatePresentation(popup);
            }
        });
        popup.registerAction("restoreDefaultExecutor", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationAction.this.myCurrentExecutor = ChooseRunConfigurationAction.this.getDefaultExecutor();
                ChooseRunConfigurationAction.this.updatePresentation(popup);
            }
        });
        popup.registerAction("invokeAction", KeyStroke.getKeyStroke("shift ENTER"), new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    popup.handleSelect(true);
                }
                finally {
                    ChooseRunConfigurationAction.this.myCurrentExecutor = null;
                }
            }
        });
        popup.registerAction("editConfiguration", KeyStroke.getKeyStroke("F4"), new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationAction.this.myEditConfiguration = true;
                try {
                    popup.handleSelect(true);
                }
                finally {
                    ChooseRunConfigurationAction.this.myEditConfiguration = false;
                }
            }
        });
        popup.registerAction("deleteConfiguration", KeyStroke.getKeyStroke("DELETE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.removeSelected();
            }
        });
        Action action0 = ChooseRunConfigurationAction.createNumberAction(0, popup, this.getDefaultExecutor());
        Action action0_ = ChooseRunConfigurationAction.createNumberAction(0, popup, this.getAlternateExecutor());
        popup.registerAction("0Action", KeyStroke.getKeyStroke("0"), action0);
        popup.registerAction("0Action_", KeyStroke.getKeyStroke("shift pressed 0"), action0_);
        popup.registerAction("0Action1", KeyStroke.getKeyStroke("NUMPAD0"), action0);
        popup.registerAction("0Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD0"), action0_);
        Action action1 = ChooseRunConfigurationAction.createNumberAction(1, popup, this.getDefaultExecutor());
        Action action1_ = ChooseRunConfigurationAction.createNumberAction(1, popup, this.getAlternateExecutor());
        popup.registerAction("1Action", KeyStroke.getKeyStroke("1"), action1);
        popup.registerAction("1Action_", KeyStroke.getKeyStroke("shift pressed 1"), action1_);
        popup.registerAction("1Action1", KeyStroke.getKeyStroke("NUMPAD1"), action1);
        popup.registerAction("1Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD1"), action1_);
        Action action2 = ChooseRunConfigurationAction.createNumberAction(2, popup, this.getDefaultExecutor());
        Action action2_ = ChooseRunConfigurationAction.createNumberAction(2, popup, this.getAlternateExecutor());
        popup.registerAction("2Action", KeyStroke.getKeyStroke("2"), action2);
        popup.registerAction("2Action_", KeyStroke.getKeyStroke("shift pressed 2"), action2_);
        popup.registerAction("2Action1", KeyStroke.getKeyStroke("NUMPAD2"), action2);
        popup.registerAction("2Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD2"), action2_);
        Action action3 = ChooseRunConfigurationAction.createNumberAction(3, popup, this.getDefaultExecutor());
        Action action3_ = ChooseRunConfigurationAction.createNumberAction(3, popup, this.getAlternateExecutor());
        popup.registerAction("3Action", KeyStroke.getKeyStroke("3"), action3);
        popup.registerAction("3Action_", KeyStroke.getKeyStroke("shift pressed 3"), action3_);
        popup.registerAction("3Action1", KeyStroke.getKeyStroke("NUMPAD3"), action3);
        popup.registerAction("3Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD3"), action3_);
    }

    private void updatePresentation(ListPopupImpl listPopup) {
        Executor executor = this.getCurrentExecutor();
        if (executor != null) {
            listPopup.setCaption(executor.getActionName());
        }
    }

    static void execute(final ItemWrapper itemWrapper, final Executor executor) {
        if (executor == null) {
            return;
        }
        final DataContext dataContext = DataManager.getInstance().getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    itemWrapper.perform(project, executor, dataContext);
                }
            });
        }
    }

    void editConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettingsImpl configuration) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction.editConfiguration must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction.editConfiguration must not be null");
        }
        Executor executor = this.getCurrentExecutor();
        assert (executor != null);
        PropertiesComponent.getInstance().setValue("run.configuration.edit.ad", Boolean.toString(true));
        if (RunDialog.editConfiguration(project, configuration, "Edit configuration settings", executor.getActionName(), executor.getIcon())) {
            RunManagerEx.getInstanceEx(project).setSelectedConfiguration(configuration);
            ExecutionUtil.executeConfiguration(project, configuration, executor);
        }
    }

    private static void deleteConfiguration(Project project, @NotNull RunnerAndConfigurationSettingsImpl configurationSettings) {
        if (configurationSettings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction.deleteConfiguration must not be null");
        }
        RunManagerEx manager = RunManagerEx.getInstanceEx(project);
        manager.removeConfiguration(configurationSettings);
    }

    @Nullable
    protected Executor getDefaultExecutor() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    @Nullable
    protected Executor getAlternateExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
    }

    @Nullable
    protected Executor getCurrentExecutor() {
        return this.myCurrentExecutor == null ? this.getDefaultExecutor() : this.myCurrentExecutor;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        presentation.setEnabled(true);
        if (project == null || project.isDisposed()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        if (null == this.getDefaultExecutor()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }

    private static Action createNumberAction(final int number, final ListPopupImpl listPopup, final Executor executor) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (final Object item : listPopup.getListStep().getValues()) {
                    if (!(item instanceof ItemWrapper) || ((ItemWrapper)item).getMnemonic() != number) continue;
                    listPopup.setFinalRunnable(new Runnable(){

                        @Override
                        public void run() {
                            ChooseRunConfigurationAction.execute((ItemWrapper)item, executor);
                        }
                    });
                    listPopup.cancel();
                }
            }
        };
    }

    private static abstract class RunListPopup
    extends ListPopupImpl {
        private Project myProject_;

        public RunListPopup(Project project, ListPopupStep step) {
            super(step);
            this.myProject_ = project;
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (e instanceof MouseEvent && e.isShiftDown()) {
                this.handleShiftClick(handleFinalChoices, e, this);
                return;
            }
            this._handleSelect(handleFinalChoices, e);
        }

        protected void _handleSelect(boolean handleFinalChoices, InputEvent e) {
            super.handleSelect(handleFinalChoices, e);
        }

        protected abstract void handleShiftClick(boolean var1, InputEvent var2, RunListPopup var3);

        @Override
        protected boolean isActionClick(MouseEvent e) {
            if (e.getButton() == 2 || e.isPopupTrigger() || e.getID() != 501) {
                return false;
            }
            return e.getButton() == 1;
        }

        @Override
        protected ListCellRenderer getListElementRenderer() {
            return new RunListElementRenderer(this);
        }

        public void removeSelected() {
            int index;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            if (!propertiesComponent.isTrueValue("run.configuration.delete.ad")) {
                propertiesComponent.setValue("run.configuration.delete.ad", Boolean.toString(true));
            }
            if ((index = this.getSelectedIndex()) == -1) {
                return;
            }
            Object o = this.getListModel().get(index);
            if (o != null && o instanceof ItemWrapper && ((ItemWrapper)o).canBeDeleted()) {
                ChooseRunConfigurationAction.deleteConfiguration(this.myProject_, (RunnerAndConfigurationSettingsImpl)((ItemWrapper)o).getValue());
                this.getListModel().deleteItem(o);
                List values = this.getListStep().getValues();
                values.remove(o);
                if (index < values.size()) {
                    this.onChildSelectedFor(values.get(index));
                } else if (index - 1 >= 0) {
                    this.onChildSelectedFor(values.get(index - 1));
                }
            }
        }
    }

    private static class RunListElementRenderer
    extends PopupListElementRenderer {
        private JLabel myLabel;
        private ListPopupImpl myPopup1;

        private RunListElementRenderer(ListPopupImpl popup) {
            super(popup);
            this.myPopup1 = popup;
        }

        @Override
        protected JComponent createItemComponent() {
            if (this.myLabel == null) {
                this.myLabel = new JLabel();
                this.myLabel.setPreferredSize(new JLabel("8.").getPreferredSize());
            }
            JComponent result = super.createItemComponent();
            result.add((Component)this.myLabel, "West");
            return result;
        }

        @Override
        protected void customizeComponent(JList list, Object value, boolean isSelected) {
            super.customizeComponent(list, value, isSelected);
            ListPopupStep<Object> step = this.myPopup1.getListStep();
            boolean isSelectable = step.isSelectable(value);
            this.myLabel.setEnabled(isSelectable);
            if (isSelected) {
                this.setSelected(this.myLabel);
            } else {
                this.setDeselected(this.myLabel);
            }
            if (value instanceof ItemWrapper) {
                int mnemonic = ((ItemWrapper)value).getMnemonic();
                if (mnemonic != -1) {
                    this.myLabel.setText(mnemonic + ".");
                    this.myLabel.setDisplayedMnemonicIndex(0);
                } else {
                    this.myLabel.setText("");
                }
            }
        }
    }

    private static abstract class ActionWrapper {
        private String myName;
        private Icon myIcon;

        private ActionWrapper(String name, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
        }

        public abstract void perform();

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static final class ConfigurationActionsStep
    extends BaseListPopupStep<ActionWrapper> {
        private ConfigurationActionsStep(@NotNull Project project, ChooseRunConfigurationAction action, @NotNull RunnerAndConfigurationSettingsImpl settings, boolean dynamic) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationActionsStep.<init> must not be null");
            }
            if (settings == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationActionsStep.<init> must not be null");
            }
            super("Actions", (Object[])ConfigurationActionsStep.buildActions(project, action, settings, dynamic));
        }

        private static ActionWrapper[] buildActions(final @NotNull Project project, final ChooseRunConfigurationAction action, final @NotNull RunnerAndConfigurationSettingsImpl settings, final boolean dynamic) {
            Executor[] executors;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationActionsStep.buildActions must not be null");
            }
            if (settings == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationActionsStep.buildActions must not be null");
            }
            ArrayList<ActionWrapper> result = new ArrayList<ActionWrapper>();
            for (final Executor executor : executors = ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)settings.getConfiguration());
                if (runner == null) continue;
                result.add(new ActionWrapper(executor.getActionName(), executor.getIcon()){

                    @Override
                    public void perform() {
                        RunManagerEx manager = RunManagerEx.getInstanceEx(project);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.setSelectedConfiguration(settings);
                        ExecutionUtil.executeConfiguration(project, settings, executor);
                    }
                });
            }
            result.add(new ActionWrapper("Edit...", EDIT_ICON){

                @Override
                public void perform() {
                    RunManagerEx manager = RunManagerEx.getInstanceEx(project);
                    if (dynamic) {
                        manager.setTemporaryConfiguration(settings);
                    }
                    action.editConfiguration(project, settings);
                }
            });
            if (RunManager.getInstance((Project)project).isTemporary(settings.getConfiguration()) || dynamic) {
                result.add(new ActionWrapper("Save temp configuration", SAVE_ICON){

                    @Override
                    public void perform() {
                        RunManagerEx manager = RunManagerEx.getInstanceEx(project);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.makeStable(settings.getConfiguration());
                    }
                });
            }
            return result.toArray(new ActionWrapper[result.size()]);
        }

        public PopupStep onChosen(final ActionWrapper selectedValue, boolean finalChoice) {
            return this.doFinalStep(new Runnable(){

                @Override
                public void run() {
                    selectedValue.perform();
                }
            });
        }

        public Icon getIconFor(ActionWrapper aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ActionWrapper value) {
            String string = value.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationActionsStep.getTextFor must not return null");
            }
            return string;
        }
    }

    private static final class ConfigurationListPopupStep
    extends BaseListPopupStep<ItemWrapper> {
        private Project myProject;
        private ChooseRunConfigurationAction myAction;
        private int myDefaultConfiguration;

        private ConfigurationListPopupStep(@NotNull ChooseRunConfigurationAction action, @NotNull Project project, @NotNull String title) {
            if (action == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep.<init> must not be null");
            }
            if (project == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep.<init> must not be null");
            }
            if (title == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep.<init> must not be null");
            }
            super(title, (Object[])ConfigurationListPopupStep.createSettingsList(project));
            this.myDefaultConfiguration = -1;
            this.myProject = project;
            this.myAction = action;
            if (-1 == this.getDefaultOptionIndex()) {
                this.myDefaultConfiguration = this.getDynamicIndex();
            }
        }

        private int getDynamicIndex() {
            int i = 0;
            for (ItemWrapper wrapper : this.getValues()) {
                if (wrapper.isDynamic()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        private static ItemWrapper[] createSettingsList(@NotNull Project project) {
            ConfigurationType[] factories;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep.createSettingsList must not be null");
            }
            RunManagerEx manager = RunManagerEx.getInstanceEx(project);
            ArrayList<ItemWrapper> result = new ArrayList<ItemWrapper>();
            RunnerAndConfigurationSettingsImpl selectedConfiguration = manager.getSelectedConfiguration();
            LinkedHashMap<RunnerAndConfigurationSettingsImpl, ItemWrapper> wrappedExisting = new LinkedHashMap<RunnerAndConfigurationSettingsImpl, ItemWrapper>();
            for (ConfigurationType factory : factories = manager.getConfigurationFactories()) {
                RunnerAndConfigurationSettingsImpl[] configurations;
                for (RunnerAndConfigurationSettingsImpl configuration : configurations = manager.getConfigurationSettings(factory)) {
                    ItemWrapper wrapped = ItemWrapper.wrap(project, configuration);
                    if (configuration == selectedConfiguration) {
                        wrapped.setMnemonic(1);
                    }
                    wrappedExisting.put(configuration, wrapped);
                }
            }
            ConfigurationListPopupStep.populateWithDynamicRunners(result, wrappedExisting, project, manager, selectedConfiguration);
            result.addAll(wrappedExisting.values());
            ItemWrapper edit = new ItemWrapper((Object)null){

                @Override
                public Icon getIcon() {
                    return EDIT_ICON;
                }

                @Override
                public String getText() {
                    return "Edit configurations...";
                }

                @Override
                public void perform(final @NotNull Project project, final @NotNull Executor executor, @NotNull DataContext context) {
                    if (project == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$1.perform must not be null");
                    }
                    if (executor == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$1.perform must not be null");
                    }
                    if (context == null) {
                        throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$1.perform must not be null");
                    }
                    EditConfigurationsDialog dialog = new EditConfigurationsDialog(project){

                        protected void init() {
                            this.setOKButtonText(executor.getStartActionText());
                            this.setOKButtonIcon(executor.getIcon());
                            super.init();
                        }
                    };
                    dialog.show();
                    if (dialog.isOK()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                                if (configuration instanceof RunnerAndConfigurationSettingsImpl && ChooseRunConfigurationAction.canRun(executor, (RunnerAndConfigurationSettingsImpl)configuration)) {
                                    ExecutionUtil.executeConfiguration(project, (RunnerAndConfigurationSettingsImpl)configuration, executor);
                                }
                            }
                        });
                    }
                }

                @Override
                public boolean available(Executor executor) {
                    return true;
                }
            };
            edit.setMnemonic(0);
            result.add(0, edit);
            return result.toArray(new ItemWrapper[result.size()]);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        private static List<RunnerAndConfigurationSettingsImpl> populateWithDynamicRunners(List<ItemWrapper> result, Map<RunnerAndConfigurationSettingsImpl, ItemWrapper> existing, final Project project, final RunManagerEx manager, RunnerAndConfigurationSettingsImpl selectedConfiguration) {
            List<RunnerAndConfigurationSettingsImpl> list;
            ArrayList<RunnerAndConfigurationSettingsImpl> contextConfigurations = new ArrayList<RunnerAndConfigurationSettingsImpl>();
            DataContext dataContext = DataManager.getInstance().getDataContext();
            ConfigurationContext context = new ConfigurationContext(dataContext);
            List<RuntimeConfigurationProducer> producers = PreferedProducerFind.findPreferredProducers(context.getLocation(), context, false);
            if (producers == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep.populateWithDynamicRunners must not return null");
                return list;
            }
            Collections.sort(producers, new Comparator<RuntimeConfigurationProducer>(){

                @Override
                public int compare(RuntimeConfigurationProducer p1, RuntimeConfigurationProducer p2) {
                    return p1.getConfigurationType().getDisplayName().compareTo(p2.getConfigurationType().getDisplayName());
                }
            });
            RunnerAndConfigurationSettingsImpl[] preferred = new RunnerAndConfigurationSettingsImpl[]{null};
            int i = 2;
            for (RuntimeConfigurationProducer producer : producers) {
                ItemWrapper wrapper;
                final RunnerAndConfigurationSettingsImpl configuration = producer.getConfiguration();
                if (configuration == null) continue;
                if (existing.keySet().contains(configuration)) {
                    wrapper = existing.get(configuration);
                    if (wrapper.getMnemonic() == 1) continue;
                    wrapper.setMnemonic(i);
                    ++i;
                    continue;
                }
                if (selectedConfiguration != null && configuration.equals(selectedConfiguration)) continue;
                contextConfigurations.add(configuration);
                if (preferred[0] == null) {
                    preferred[0] = configuration;
                }
                wrapper = new ItemWrapper(configuration){

                    @Override
                    public Icon getIcon() {
                        return IconLoader.getTransparentIcon((Icon)ExecutionUtil.getConfigurationIcon(project, configuration), (float)0.3f);
                    }

                    @Override
                    public String getText() {
                        return String.format("%s", configuration.getName());
                    }

                    @Override
                    public boolean available(Executor executor) {
                        return ChooseRunConfigurationAction.canRun(executor, configuration);
                    }

                    @Override
                    public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                        if (project2 == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$3.perform must not be null");
                        }
                        if (executor == null) {
                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$3.perform must not be null");
                        }
                        if (context == null) {
                            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$3.perform must not be null");
                        }
                        manager.setTemporaryConfiguration(configuration);
                        RunManagerEx.getInstanceEx(project2).setSelectedConfiguration(configuration);
                        ExecutionUtil.executeConfiguration(project2, configuration, executor);
                    }

                    @Override
                    public PopupStep getNextStep(@NotNull Project project2, @NotNull ChooseRunConfigurationAction action) {
                        if (project2 == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$3.getNextStep must not be null");
                        }
                        if (action == null) {
                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep$3.getNextStep must not be null");
                        }
                        return new ConfigurationActionsStep(project2, action, configuration, this.isDynamic());
                    }

                    @Override
                    public boolean hasActions() {
                        return true;
                    }
                };
                wrapper.setDynamic(true);
                wrapper.setMnemonic(i);
                result.add(wrapper);
                ++i;
            }
            list = contextConfigurations;
            if (list != null) return list;
            throw new IllegalStateException("@NotNull method com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep.populateWithDynamicRunners must not return null");
        }

        public ListSeparator getSeparatorAbove(ItemWrapper value) {
            List configurations = this.getValues();
            int index = configurations.indexOf(value);
            if (index > 0 && index <= configurations.size() - 1) {
                ConfigurationType aboveType;
                ItemWrapper aboveConfiguration;
                ItemWrapper itemWrapper = aboveConfiguration = index == 0 ? null : (ItemWrapper)configurations.get(index - 1);
                if (aboveConfiguration != null && aboveConfiguration.isDynamic() != value.isDynamic()) {
                    return new ListSeparator();
                }
                ConfigurationType currentType = value.getType();
                ConfigurationType configurationType = aboveType = aboveConfiguration == null ? null : aboveConfiguration.getType();
                if (aboveType != currentType && currentType != null) {
                    return new ListSeparator();
                }
            }
            return null;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public int getDefaultOptionIndex() {
            RunnerAndConfigurationSettings currentConfiguration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            if (currentConfiguration == null && this.myDefaultConfiguration != -1) {
                return this.myDefaultConfiguration;
            }
            return currentConfiguration instanceof RunnerAndConfigurationSettingsImpl ? this.getValues().indexOf(ItemWrapper.wrap(this.myProject, (RunnerAndConfigurationSettingsImpl)currentConfiguration)) : -1;
        }

        public PopupStep onChosen(final ItemWrapper wrapper, boolean finalChoice) {
            Object o;
            if (this.myAction.myEditConfiguration && (o = wrapper.getValue()) instanceof RunnerAndConfigurationSettingsImpl) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        ConfigurationListPopupStep.this.myAction.editConfiguration(ConfigurationListPopupStep.this.myProject, (RunnerAndConfigurationSettingsImpl)o);
                    }
                });
            }
            final Executor executor = this.myAction.getCurrentExecutor();
            assert (executor != null);
            if (finalChoice && wrapper.available(executor)) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        if (executor == ConfigurationListPopupStep.this.myAction.getAlternateExecutor()) {
                            PropertiesComponent.getInstance().setValue(ConfigurationListPopupStep.this.myAction.getAdKey(), Boolean.toString(true));
                        }
                        wrapper.perform(ConfigurationListPopupStep.this.myProject, executor, DataManager.getInstance().getDataContext());
                    }
                });
            }
            return wrapper.getNextStep(this.myProject, this.myAction);
        }

        public boolean hasSubstep(ItemWrapper selectedValue) {
            return selectedValue.hasActions();
        }

        @NotNull
        public String getTextFor(ItemWrapper value) {
            String string = value.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/execution/actions/ChooseRunConfigurationAction$ConfigurationListPopupStep.getTextFor must not return null");
            }
            return string;
        }

        public Icon getIconFor(ItemWrapper value) {
            return value.getIcon();
        }
    }

    private static abstract class ItemWrapper<T> {
        private T myValue;
        private boolean myDynamic = false;
        private int myMnemonic = -1;

        protected ItemWrapper(@Nullable T value) {
            this.myValue = value;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        public void setMnemonic(int mnemonic) {
            this.myMnemonic = mnemonic;
        }

        public T getValue() {
            return this.myValue;
        }

        public boolean isDynamic() {
            return this.myDynamic;
        }

        public void setDynamic(boolean b) {
            this.myDynamic = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemWrapper)) {
                return false;
            }
            ItemWrapper that = (ItemWrapper)o;
            return !(this.myValue != null ? !this.myValue.equals(that.myValue) : that.myValue != null);
        }

        public int hashCode() {
            return this.myValue != null ? this.myValue.hashCode() : 0;
        }

        public abstract Icon getIcon();

        public abstract String getText();

        public abstract void perform(@NotNull Project var1, @NotNull Executor var2, @NotNull DataContext var3);

        @Nullable
        public ConfigurationType getType() {
            return null;
        }

        public boolean available(Executor executor) {
            return false;
        }

        public boolean hasActions() {
            return false;
        }

        public PopupStep getNextStep(Project project, ChooseRunConfigurationAction action) {
            return PopupStep.FINAL_CHOICE;
        }

        public static ItemWrapper wrap(@NotNull Project project, @NotNull RunnerAndConfigurationSettingsImpl settings, boolean dynamic) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper.wrap must not be null");
            }
            if (settings == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper.wrap must not be null");
            }
            ItemWrapper result = ItemWrapper.wrap(project, settings);
            result.setDynamic(dynamic);
            return result;
        }

        public static ItemWrapper wrap(final @NotNull Project project, @NotNull RunnerAndConfigurationSettingsImpl settings) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper.wrap must not be null");
            }
            if (settings == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper.wrap must not be null");
            }
            return new ItemWrapper<RunnerAndConfigurationSettingsImpl>(settings){

                @Override
                public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project2 == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper$1.perform must not be null");
                    }
                    if (executor == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper$1.perform must not be null");
                    }
                    if (context == null) {
                        throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper$1.perform must not be null");
                    }
                    RunManagerEx.getInstanceEx(project2).setSelectedConfiguration((RunnerAndConfigurationSettingsImpl)this.getValue());
                    ExecutionUtil.executeConfiguration(project2, (RunnerAndConfigurationSettingsImpl)this.getValue(), executor);
                }

                @Override
                public ConfigurationType getType() {
                    return ((RunnerAndConfigurationSettingsImpl)this.getValue()).getType();
                }

                @Override
                public Icon getIcon() {
                    return ExecutionUtil.getConfigurationIcon(project, (RunnerAndConfigurationSettings)this.getValue());
                }

                @Override
                public String getText() {
                    if (this.getMnemonic() != -1) {
                        return String.format("%s", ((RunnerAndConfigurationSettingsImpl)this.getValue()).getName());
                    }
                    return ((RunnerAndConfigurationSettingsImpl)this.getValue()).getName();
                }

                @Override
                public boolean hasActions() {
                    return true;
                }

                @Override
                public boolean available(Executor executor) {
                    return null != ExecutionUtil.getRunner(executor.getId(), (RunnerAndConfigurationSettingsImpl)this.getValue());
                }

                @Override
                public PopupStep getNextStep(@NotNull Project project2, @NotNull ChooseRunConfigurationAction action) {
                    if (project2 == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper$1.getNextStep must not be null");
                    }
                    if (action == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/actions/ChooseRunConfigurationAction$ItemWrapper$1.getNextStep must not be null");
                    }
                    return new ConfigurationActionsStep(project2, action, (RunnerAndConfigurationSettingsImpl)this.getValue(), this.isDynamic());
                }
            };
        }

        public boolean canBeDeleted() {
            return !this.isDynamic() && this.getValue() != null;
        }
    }
}

