/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubmitPerformanceReportAction
extends AnAction
implements DumbAware {
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private static final String MESSAGE_TITLE = "Submit Performance Report";

    public void actionPerformed(AnActionEvent e) {
        String reportFileName = "perf_" + ApplicationInfo.getInstance().getBuild().asString() + "_" + SystemProperties.getUserName() + "_" + this.myDateFormat.format(new Date()) + ".zip";
        final File reportPath = new File(SystemProperties.getUserHome(), reportFileName);
        final File logDir = new File(PathManager.getLogPath());
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final boolean[] archiveCreated = new boolean[1];
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(reportPath));
                    ZipUtil.addDirToZipRecursively((ZipOutputStream)zip, (File)reportPath, (File)logDir, (String)"", (FileFilter)new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            ProgressManager.checkCanceled();
                            if (logDir.equals(pathname.getParentFile())) {
                                return pathname.getPath().contains("threadDumps");
                            }
                            return true;
                        }
                    }, null);
                    zip.close();
                    archiveCreated[0] = true;
                }
                catch (IOException ex) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)("Failed to create performance report archive: " + ex.getMessage()), (String)SubmitPerformanceReportAction.MESSAGE_TITLE);
                        }
                    });
                }
            }
        }, "Collecting Performance Report data", true, project);
        if (!completed || !archiveCreated[0]) {
            return;
        }
        int rc = Messages.showYesNoDialog((Project)project, (String)("The performance report has been saved to\n" + reportPath + "\n\nWould you like to submit it to JetBrains?"), (String)MESSAGE_TITLE, (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Uploading Performance Report"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/diagnostic/SubmitPerformanceReportAction$2.run must not be null");
                    }
                    final String error = SubmitPerformanceReportAction.uploadFileToFTP(reportPath, "ftp.intellij.net", ".uploads", indicator);
                    if (error != null) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showErrorDialog((String)error, (String)SubmitPerformanceReportAction.MESSAGE_TITLE);
                            }
                        });
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String uploadFileToFTP(File reportPath, @NonNls String ftpSite, @NonNls String directory, ProgressIndicator indicator) {
        FTPClient ftp = new FTPClient();
        ftp.setConnectTimeout(30000);
        try {
            indicator.setText("Connecting to server...");
            ftp.connect(ftpSite);
            indicator.setText("Connected to server");
            if (!ftp.login("anonymous", "anonymous@jetbrains.com")) {
                String string = "Failed to login";
                return string;
            }
            indicator.setText("Logged in");
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                String ioe = "FTP server refused connection: " + reply;
                return ioe;
            }
            if (!ftp.changeWorkingDirectory(directory)) {
                String ioe = "Failed to change directory";
                return ioe;
            }
            ftp.enterLocalPassiveMode();
            if (!ftp.setFileType(2)) {
                String ioe = "Failed to switch to binary mode";
                return ioe;
            }
            indicator.setText("Transferring (" + StringUtil.formatFileSize((long)reportPath.length()) + ")");
            FileInputStream readStream = new FileInputStream(reportPath);
            try {
                if (!ftp.storeFile(reportPath.getName(), (InputStream)readStream)) {
                    String ioe = "Failed to upload file";
                    return ioe;
                }
            }
            catch (IOException e) {
                String ioe = "Error during transfer: " + e.getMessage();
                return ioe;
            }
            ftp.logout();
            String e = null;
            return e;
            finally {
                readStream.close();
            }
        }
        catch (IOException e) {
            String string = "Failed to upload: " + e.getMessage();
            return string;
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

