/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class CompoundNodeRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "CompoundNodeRenderer";
    protected ValueLabelRenderer myLabelRenderer;
    protected ChildrenRenderer myChildrenRenderer;
    protected final NodeRendererSettings myRendererSettings;

    public CompoundNodeRenderer(NodeRendererSettings rendererSettings, String name, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        this.myRendererSettings = rendererSettings;
        this.setName(name);
        this.myLabelRenderer = labelRenderer;
        this.myChildrenRenderer = childrenRenderer;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public CompoundNodeRenderer clone() {
        CompoundNodeRenderer renderer = (CompoundNodeRenderer)super.clone();
        renderer.myLabelRenderer = this.myLabelRenderer != null ? (ValueLabelRenderer)this.myLabelRenderer.clone() : null;
        renderer.myChildrenRenderer = this.myChildrenRenderer != null ? (ChildrenRenderer)this.myChildrenRenderer.clone() : null;
        return renderer;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        this.getChildrenRenderer().buildChildren(value, builder, evaluationContext);
    }

    @Override
    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return this.getChildrenRenderer().getChildValueExpression(node, context);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return this.getChildrenRenderer().isExpandable(value, evaluationContext, parentDescriptor);
    }

    @Override
    public boolean isApplicable(Type type) {
        return this.getLabelRenderer().isApplicable(type) && this.getChildrenRenderer().isApplicable(type);
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        return this.getLabelRenderer().calcLabel(descriptor, evaluationContext, listener);
    }

    public ValueLabelRenderer getLabelRenderer() {
        return this.myLabelRenderer;
    }

    public ChildrenRenderer getChildrenRenderer() {
        return this.myChildrenRenderer;
    }

    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        this.myLabelRenderer = labelRenderer;
    }

    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        this.myChildrenRenderer = childrenRenderer;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        List children = element.getChildren("Renderer");
        if (children != null) {
            for (Element elem : children) {
                String role = elem.getAttributeValue("role");
                if (role == null) continue;
                if ("label".equals(role)) {
                    this.myLabelRenderer = (ValueLabelRenderer)this.myRendererSettings.readRenderer(elem);
                    continue;
                }
                if (!"children".equals(role)) continue;
                this.myChildrenRenderer = (ChildrenRenderer)this.myRendererSettings.readRenderer(elem);
            }
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myLabelRenderer != null) {
            Element labelRendererElement = this.myRendererSettings.writeRenderer(this.myLabelRenderer);
            labelRendererElement.setAttribute("role", "label");
            element.addContent(labelRendererElement);
        }
        if (this.myChildrenRenderer != null) {
            Element childrenRendererElement = this.myRendererSettings.writeRenderer(this.myChildrenRenderer);
            childrenRendererElement.setAttribute("role", "children");
            element.addContent(childrenRendererElement);
        }
    }
}

