/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class CompoundNodeConfigurable
implements UnnamedConfigurable {
    private final CompoundNodeRenderer myRenderer;
    private final UnnamedConfigurable myLabelConfigurable;
    private final UnnamedConfigurable myChildrenConfigurable;
    private static final UnnamedConfigurable NULL_CONFIGURABLE = new UnnamedConfigurable(){

        public JComponent createComponent() {
            return new JPanel();
        }

        public boolean isModified() {
            return false;
        }

        public void apply() {
        }

        public void reset() {
        }

        public void disposeUIResources() {
        }
    };

    public CompoundNodeConfigurable(CompoundNodeRenderer renderer, UnnamedConfigurable labelConfigurable, UnnamedConfigurable childrenConfigurable) {
        this.myRenderer = renderer;
        this.myLabelConfigurable = labelConfigurable != null ? labelConfigurable : NULL_CONFIGURABLE;
        this.myChildrenConfigurable = childrenConfigurable != null ? childrenConfigurable : NULL_CONFIGURABLE;
    }

    public CompoundNodeRenderer getRenderer() {
        return this.myRenderer;
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridwidth = 0;
        panel.add((Component)this.myLabelConfigurable.createComponent(), c);
        c.ipady = 1;
        panel.add((Component)new JSeparator(0), c);
        c.ipady = 0;
        c.weighty = 1.0;
        panel.add((Component)this.myChildrenConfigurable.createComponent(), c);
        return panel;
    }

    public boolean isModified() {
        return this.myLabelConfigurable.isModified() || this.myChildrenConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myLabelConfigurable.apply();
        this.myChildrenConfigurable.apply();
    }

    public void reset() {
        this.myLabelConfigurable.reset();
        this.myChildrenConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myLabelConfigurable.disposeUIResources();
        this.myChildrenConfigurable.disposeUIResources();
    }
}

