/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FrameDebuggerTree
extends DebuggerTree {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.FrameDebuggerTree");
    private boolean myAnyNewLocals;
    private boolean myAutoWatchMode = false;

    public FrameDebuggerTree(Project project) {
        super(project);
    }

    public boolean isAutoWatchMode() {
        return this.myAutoWatchMode;
    }

    public void setAutoVariablesMode(boolean autoWatchMode) {
        boolean valueChanged = this.myAutoWatchMode != autoWatchMode;
        this.myAutoWatchMode = autoWatchMode;
        if (valueChanged) {
            this.rebuild(this.getDebuggerContext());
        }
    }

    @Override
    protected void build(DebuggerContextImpl context) {
        this.myAnyNewLocals = false;
        this.buildWhenPaused(context, new RefreshFrameTreeCommand(context));
    }

    @Override
    public void restoreNodeState(DebuggerTreeNodeImpl node) {
        if (this.myAnyNewLocals) {
            NodeDescriptorImpl descriptor = node.getDescriptor();
            boolean isLocalVar = descriptor instanceof LocalVariableDescriptorImpl;
            descriptor.myIsSelected &= isLocalVar;
            boolean bl = descriptor.myIsVisible = isLocalVar && descriptor.myIsSelected;
            if (!descriptor.myIsVisible) {
                descriptor.putUserData(VISIBLE_RECT, null);
            }
        }
        super.restoreNodeState(node);
        if (this.myAnyNewLocals && node.getDescriptor().myIsExpanded) {
            DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getMutableModel().getRoot();
            this.scrollToVisible(root);
        }
    }

    @Override
    protected DebuggerTree.BuildNodeCommand getBuildNodeCommand(DebuggerTreeNodeImpl node) {
        if (node.getDescriptor() instanceof StackFrameDescriptorImpl) {
            return new BuildFrameTreeVariablesCommand(node);
        }
        return super.getBuildNodeCommand(node);
    }

    private static Map<String, LocalVariableProxyImpl> getVisibleVariables(StackFrameDescriptorImpl stackDescriptor) throws EvaluateException {
        StackFrameProxyImpl frame = stackDescriptor.getFrameProxy();
        if (frame == null) {
            return Collections.emptyMap();
        }
        HashMap<String, LocalVariableProxyImpl> vars = new HashMap<String, LocalVariableProxyImpl>();
        for (LocalVariableProxyImpl localVariableProxy : frame.visibleVariables()) {
            vars.put(localVariableProxy.name(), localVariableProxy);
        }
        return vars;
    }

    private static boolean shouldSkipLine(PsiFile file, Document doc, int line) {
        int start = doc.getLineStartOffset(line);
        int end = doc.getLineEndOffset(line);
        int _start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)start, (String)" \n\t");
        if (_start >= end) {
            return true;
        }
        TextRange alreadyChecked = null;
        for (PsiElement elem = file.findElementAt(_start); !(elem == null || elem.getTextOffset() > end || alreadyChecked != null && alreadyChecked.contains(elem.getTextRange())); elem = elem.getNextSibling()) {
            PsiElement _elem = elem;
            while (_elem.getTextOffset() >= _start) {
                PsiElement resolved;
                alreadyChecked = _elem.getTextRange();
                if (_elem instanceof PsiDeclarationStatement) {
                    PsiElement[] declared;
                    for (PsiElement declaredElement : declared = ((PsiDeclarationStatement)_elem).getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiVariable)) continue;
                        return false;
                    }
                }
                if (_elem instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)_elem).resolve()) instanceof PsiVariable) {
                    return false;
                }
                _elem = _elem.getParent();
            }
        }
        return true;
    }

    private static Pair<Set<String>, Set<TextWithImports>> findReferencedVars(Set<String> visibleVars, SourcePosition position) {
        int offset;
        PsiElement element;
        int endLine;
        Document doc;
        int line = position.getLine();
        if (line < 0) {
            return new Pair(Collections.emptySet(), Collections.emptySet());
        }
        PsiFile positionFile = position.getFile();
        VirtualFile vFile = positionFile.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return new Pair(Collections.emptySet(), Collections.emptySet());
        }
        TextRange limit = FrameDebuggerTree.calculateLimitRange(positionFile, doc, line);
        int startLine = Math.max(limit.getStartOffset(), line - 1);
        for (startLine = Math.min(startLine, limit.getEndOffset()); startLine > limit.getStartOffset() && FrameDebuggerTree.shouldSkipLine(positionFile, doc, startLine); --startLine) {
        }
        int startOffset = doc.getLineStartOffset(startLine);
        for (endLine = Math.min(line + 2, limit.getEndOffset()); endLine < limit.getEndOffset() && FrameDebuggerTree.shouldSkipLine(positionFile, doc, endLine); ++endLine) {
        }
        int endOffset = doc.getLineEndOffset(endLine);
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (!lineRange.isEmpty() && (element = positionFile.findElementAt(offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \t"))) != null) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class});
            if (method != null) {
                element = method;
            } else {
                PsiField field = (PsiField)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiField.class});
                if (field != null) {
                    element = field;
                } else {
                    PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiClassInitializer.class});
                    if (initializer != null) {
                        element = initializer;
                    }
                }
            }
            if (element instanceof PsiCompiledElement) {
                return new Pair(visibleVars, Collections.emptySet());
            }
            HashSet<String> vars = new HashSet<String>();
            HashSet<TextWithImports> expressions = new HashSet<TextWithImports>();
            VariablesCollector variablesCollector = new VariablesCollector(visibleVars, FrameDebuggerTree.adjustRange(element, lineRange), expressions, vars);
            element.accept((PsiElementVisitor)variablesCollector);
            return new Pair(vars, expressions);
        }
        return new Pair(Collections.emptySet(), Collections.emptySet());
    }

    private static TextRange calculateLimitRange(PsiFile file, Document doc, int line) {
        int offset = doc.getLineStartOffset(line);
        if (offset > 0) {
            for (PsiElement elem = file.findElementAt(offset); elem != null; elem = elem.getParent()) {
                if (!(elem instanceof PsiMethod)) continue;
                TextRange elemRange = elem.getTextRange();
                return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
            }
        }
        return new TextRange(0, doc.getLineCount() - 1);
    }

    private static TextRange adjustRange(PsiElement element, final TextRange originalRange) {
        final Ref rangeRef = new Ref((Object)originalRange);
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitExpressionStatement(PsiExpressionStatement statement) {
                TextRange stRange = statement.getTextRange();
                if (originalRange.intersects(stRange)) {
                    TextRange currentRange = (TextRange)rangeRef.get();
                    int start = Math.min(currentRange.getStartOffset(), stRange.getStartOffset());
                    int end = Math.max(currentRange.getEndOffset(), stRange.getEndOffset());
                    rangeRef.set((Object)new TextRange(start, end));
                }
            }
        });
        return (TextRange)rangeRef.get();
    }

    private static class VariablesCollector
    extends JavaRecursiveElementVisitor {
        private final Set<String> myVisibleLocals;
        private final TextRange myLineRange;
        private final Set<TextWithImports> myExpressions;
        private final Set<String> myVars;

        public VariablesCollector(Set<String> visibleLocals, TextRange lineRange, Set<TextWithImports> expressions, Set<String> vars) {
            this.myVisibleLocals = visibleLocals;
            this.myLineRange = lineRange;
            this.myExpressions = expressions;
            this.myVars = vars;
        }

        public void visitElement(PsiElement element) {
            if (this.myLineRange.intersects(element.getTextRange())) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiMethod psiMethod = expression.resolveMethod();
            if (psiMethod != null && !this.hasSideEffects((PsiElement)expression)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiExpression)expression));
            }
            super.visitMethodCallExpression(expression);
        }

        public void visitReferenceExpression(PsiReferenceExpression reference) {
            PsiElement psiElement;
            if (this.myLineRange.intersects(reference.getTextRange()) && (psiElement = reference.resolve()) instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)psiElement;
                if (var instanceof PsiField) {
                    if (!this.hasSideEffects((PsiElement)reference)) {
                        if (var instanceof PsiEnumConstant && reference.getQualifier() == null) {
                            PsiExpression expression;
                            PsiReference ref;
                            PsiClass enumClass = ((PsiEnumConstant)var).getContainingClass();
                            if (enumClass != null && (ref = (expression = JavaPsiFacade.getInstance((Project)var.getProject()).getParserFacade().createExpressionFromText(enumClass.getName() + "." + var.getName(), (PsiElement)var)).getReference()) != null) {
                                ref.bindToElement((PsiElement)var);
                                this.myExpressions.add(new TextWithImportsImpl(expression));
                            }
                        } else {
                            this.myExpressions.add(new TextWithImportsImpl((PsiExpression)reference));
                        }
                    }
                } else if (this.myVisibleLocals.contains(var.getName())) {
                    this.myVars.add(var.getName());
                }
            }
            super.visitReferenceExpression(reference);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            if (!this.hasSideEffects((PsiElement)expression)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiExpression)expression));
            }
            super.visitArrayAccessExpression(expression);
        }

        public void visitParameter(PsiParameter parameter) {
            this.processVariable((PsiVariable)parameter);
            super.visitParameter(parameter);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            this.processVariable((PsiVariable)variable);
            super.visitLocalVariable(variable);
        }

        private void processVariable(PsiVariable variable) {
            if (this.myLineRange.intersects(variable.getTextRange()) && this.myVisibleLocals.contains(variable.getName())) {
                this.myVars.add(variable.getName());
            }
        }

        public void visitClass(PsiClass aClass) {
        }

        private boolean hasSideEffects(PsiElement element) {
            final AtomicBoolean rv = new AtomicBoolean(false);
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitPostfixExpression(PsiPostfixExpression expression) {
                    rv.set(true);
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    PsiMethod method;
                    PsiElement psiElement = expression.resolve();
                    if (psiElement instanceof PsiLocalVariable) {
                        if (!VariablesCollector.this.myVisibleLocals.contains(((PsiLocalVariable)psiElement).getName())) {
                            rv.set(true);
                        }
                    } else if (psiElement instanceof PsiMethod && !DebuggerUtils.isSimpleGetter((PsiMethod)(method = (PsiMethod)psiElement))) {
                        rv.set(true);
                    }
                    if (!rv.get()) {
                        super.visitReferenceExpression(expression);
                    }
                }

                public void visitPrefixExpression(PsiPrefixExpression expression) {
                    IElementType op = expression.getOperationTokenType();
                    if (JavaTokenType.PLUSPLUS.equals(op) || JavaTokenType.MINUSMINUS.equals(op)) {
                        rv.set(true);
                    } else {
                        super.visitPrefixExpression(expression);
                    }
                }

                public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                    rv.set(true);
                }

                public void visitCallExpression(PsiCallExpression callExpression) {
                    PsiMethod method = callExpression.resolveMethod();
                    if (method == null || !DebuggerUtils.isSimpleGetter((PsiMethod)method)) {
                        rv.set(true);
                    } else {
                        super.visitCallExpression(callExpression);
                    }
                }
            });
            return rv.get();
        }
    }

    private class RefreshFrameTreeCommand
    extends DebuggerTree.RefreshDebuggerTreeCommand {
        public RefreshFrameTreeCommand(DebuggerContextImpl context) {
            super(context);
        }

        @Override
        public void contextAction() throws Exception {
            DebuggerTreeNodeImpl rootNode;
            DebuggerContextImpl debuggerContext;
            block11: {
                debuggerContext = this.getDebuggerContext();
                ThreadReferenceProxyImpl currentThread = debuggerContext.getThreadProxy();
                if (currentThread == null) {
                    return;
                }
                try {
                    StackFrameProxyImpl frame = debuggerContext.getFrameProxy();
                    if (frame != null) {
                        NodeManagerImpl nodeManager = FrameDebuggerTree.this.getNodeFactory();
                        rootNode = nodeManager.createNode(nodeManager.getStackFrameDescriptor(null, frame), debuggerContext.createEvaluationContext());
                        break block11;
                    }
                    rootNode = FrameDebuggerTree.this.getNodeFactory().getDefaultNode();
                    SuspendManager suspendManager = this.getSuspendContext().getDebugProcess().getSuspendManager();
                    try {
                        if (suspendManager.isSuspended(currentThread)) {
                            try {
                                if (currentThread.frameCount() == 0) {
                                    rootNode.add(MessageDescriptor.THREAD_IS_EMPTY);
                                    break block11;
                                }
                                rootNode.add(MessageDescriptor.DEBUG_INFO_UNAVAILABLE);
                            }
                            catch (EvaluateException e) {
                                rootNode.add(new MessageDescriptor(e.getMessage()));
                            }
                            break block11;
                        }
                        rootNode.add(MessageDescriptor.THREAD_IS_RUNNING);
                    }
                    catch (ObjectCollectedException e) {
                        rootNode.add(new MessageDescriptor(DebuggerBundle.message((String)"label.thread.node.thread.collected", (Object[])new Object[]{currentThread.name()})));
                    }
                }
                catch (Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)ex);
                    }
                    rootNode = FrameDebuggerTree.this.getNodeFactory().getDefaultNode();
                    rootNode.add(MessageDescriptor.DEBUG_INFO_UNAVAILABLE);
                }
            }
            final DebuggerTreeNodeImpl rootNode1 = rootNode;
            DebuggerInvocationUtil.swingInvokeLater(FrameDebuggerTree.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    FrameDebuggerTree.this.getMutableModel().setRoot(rootNode1);
                    FrameDebuggerTree.this.treeChanged();
                    final TreeModel model = FrameDebuggerTree.this.getModel();
                    model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                        public void treeStructureChanged(TreeModelEvent e) {
                            Object[] path = e.getPath();
                            if (path.length > 0 && path[path.length - 1] == rootNode1) {
                                model.removeTreeModelListener((TreeModelListener)((Object)this));
                                if (ViewsGeneralSettings.getInstance().AUTOSCROLL_TO_NEW_LOCALS) {
                                    this.autoscrollToNewLocals(rootNode1);
                                } else {
                                    Enumeration children = rootNode1.rawChildren();
                                    while (children.hasMoreElements()) {
                                        DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)children.nextElement();
                                        NodeDescriptorImpl descriptor = child.getDescriptor();
                                        if (!(descriptor instanceof LocalVariableDescriptorImpl)) continue;
                                        ((LocalVariableDescriptorImpl)descriptor).setNewLocal(false);
                                    }
                                }
                            }
                        }
                    });
                }

                private void autoscrollToNewLocals(DebuggerTreeNodeImpl frameNode) {
                    DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
                    boolean isSteppingThrough = debuggerSession.isSteppingThrough(debuggerContext.getThreadProxy());
                    ArrayList<DebuggerTreeNodeImpl> toClear = new ArrayList<DebuggerTreeNodeImpl>();
                    ArrayList<DebuggerTreeNodeImpl> newLocalsToSelect = new ArrayList<DebuggerTreeNodeImpl>();
                    Enumeration e = frameNode.rawChildren();
                    while (e.hasMoreElements()) {
                        DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)e.nextElement();
                        NodeDescriptorImpl descriptor = child.getDescriptor();
                        if (!(descriptor instanceof LocalVariableDescriptorImpl)) continue;
                        LocalVariableDescriptorImpl localVariableDescriptor = (LocalVariableDescriptorImpl)descriptor;
                        if (isSteppingThrough && localVariableDescriptor.isNewLocal()) {
                            FrameDebuggerTree.this.myAnyNewLocals = true;
                            newLocalsToSelect.add(child);
                        } else {
                            toClear.add(child);
                        }
                        localVariableDescriptor.setNewLocal(false);
                    }
                    if (!newLocalsToSelect.isEmpty()) {
                        for (DebuggerTreeNodeImpl child : toClear) {
                            FrameDebuggerTree.this.removeSelectionPath(new TreePath(child.getPath()));
                            child.getDescriptor().myIsSelected = false;
                        }
                        for (DebuggerTreeNodeImpl child : newLocalsToSelect) {
                            FrameDebuggerTree.this.addSelectionPath(new TreePath(child.getPath()));
                            child.getDescriptor().myIsSelected = true;
                        }
                    }
                }
            });
        }
    }

    private class BuildFrameTreeVariablesCommand
    extends DebuggerTree.BuildStackFrameCommand {
        public BuildFrameTreeVariablesCommand(DebuggerTreeNodeImpl stackNode) {
            super(FrameDebuggerTree.this, stackNode);
        }

        @Override
        protected void buildVariables(StackFrameDescriptorImpl stackDescriptor, EvaluationContextImpl evaluationContext) throws EvaluateException {
            final SourcePosition sourcePosition = this.getDebuggerContext().getSourcePosition();
            if (sourcePosition == null) {
                return;
            }
            try {
                final Map visibleVariables = FrameDebuggerTree.getVisibleVariables(stackDescriptor);
                Pair usedVars = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<Set<String>, Set<TextWithImports>>>(){

                    public Pair<Set<String>, Set<TextWithImports>> compute() {
                        return FrameDebuggerTree.findReferencedVars(visibleVariables.keySet(), sourcePosition);
                    }
                });
                if (FrameDebuggerTree.this.myAutoWatchMode) {
                    for (String var : (Set)usedVars.first) {
                        LocalVariableDescriptorImpl descriptor = FrameDebuggerTree.this.myNodeManager.getLocalVariableDescriptor(stackDescriptor, (LocalVariableProxy)visibleVariables.get(var));
                        this.myChildren.add(FrameDebuggerTree.this.myNodeManager.createNode(descriptor, evaluationContext));
                    }
                } else {
                    super.buildVariables(stackDescriptor, evaluationContext);
                }
                EvaluationContextImpl evalContextCopy = evaluationContext.createEvaluationContext(evaluationContext.getThisObject());
                evalContextCopy.setAutoLoadClasses(false);
                for (TextWithImports text : (Set)usedVars.second) {
                    this.myChildren.add(FrameDebuggerTree.this.myNodeManager.createNode(FrameDebuggerTree.this.myNodeManager.getWatchItemDescriptor(stackDescriptor, text, null), evalContextCopy));
                }
            }
            catch (EvaluateException e) {
                if (e.getCause() instanceof AbsentInformationException) {
                    StackFrameProxyImpl frame = stackDescriptor.getFrameProxy();
                    if (frame == null) {
                        throw e;
                    }
                    List<Value> argValues = frame.getArgumentValues();
                    int index = 0;
                    for (Value argValue : argValues) {
                        ArgumentValueDescriptorImpl descriptor = FrameDebuggerTree.this.myNodeManager.getArgumentValueDescriptor(stackDescriptor, index++, argValue);
                        DebuggerTreeNodeImpl variableNode = FrameDebuggerTree.this.myNodeManager.createNode(descriptor, evaluationContext);
                        this.myChildren.add(variableNode);
                    }
                    this.myChildren.add(FrameDebuggerTree.this.myNodeManager.createMessageNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE));
                }
                throw e;
            }
        }
    }
}

