/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.DebuggerEditorImpl;
import com.intellij.debugger.ui.DebuggerRecents;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorComboBoxRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;

public class DebuggerExpressionComboBox
extends DebuggerEditorImpl {
    public static final Key<String> KEY = Key.create((String)"DebuggerComboBoxEditor.KEY");
    public static final int MAX_ROWS = 20;
    private MyEditorComboBoxEditor myEditor;
    private ComboBox myComboBox = new ComboBox(-1);
    protected TextWithImports myItem;

    @Override
    public void setText(TextWithImports item) {
        String itemText = item.getText().replace('\n', ' ');
        item.setText(itemText);
        if (!("".equals(itemText) || this.myComboBox.getItemCount() != 0 && item.equals(this.myComboBox.getItemAt(0)))) {
            this.myComboBox.insertItemAt((Object)item, 0);
        }
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
        if (this.myComboBox.isEditable()) {
            this.myComboBox.getEditor().setItem(item);
        } else {
            this.myItem = item;
        }
    }

    @Override
    public TextWithImports getText() {
        return (TextWithImports)this.myComboBox.getEditor().getItem();
    }

    protected void updateEditor(TextWithImports item) {
        if (!this.myComboBox.isEditable()) {
            return;
        }
        boolean focusOwner = this.myEditor != null && this.myEditor.getEditorComponent().isFocusOwner();
        int offset = 0;
        TextWithImports oldItem = null;
        if (focusOwner) {
            offset = this.myEditor.getEditor().getCaretModel().getOffset();
            oldItem = (TextWithImports)this.myEditor.getItem();
        }
        this.myEditor = new MyEditorComboBoxEditor(this.getProject(), (FileType)this.myFactory.getFileType());
        this.myComboBox.setEditor((ComboBoxEditor)this.myEditor);
        this.myComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)this.myEditor));
        this.myComboBox.setMaximumRowCount(20);
        this.myEditor.setItem(item);
        if (focusOwner) {
            this.myEditor.getEditorComponent().requestFocus();
            if (oldItem.equals(item)) {
                this.myEditor.getEditor().getCaretModel().moveToOffset(offset);
            }
        }
    }

    private void setRecents() {
        boolean focusOwner = this.myEditor != null && this.myEditor.getEditorComponent().isFocusOwner();
        this.myComboBox.removeAllItems();
        if (this.getRecentsId() != null) {
            LinkedList<TextWithImports> recents = DebuggerRecents.getInstance(this.getProject()).getRecents(this.getRecentsId());
            ArrayList<TextWithImports> singleLine = new ArrayList<TextWithImports>();
            for (TextWithImports evaluationText : recents) {
                if (evaluationText.getText().indexOf(10) != -1) continue;
                singleLine.add(evaluationText);
            }
            this.addRecents(singleLine);
        }
        if (focusOwner) {
            this.myEditor.getEditorComponent().requestFocus();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.width = 100;
        return size;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.myComboBox.isEditable() == enabled) {
            return;
        }
        this.myComboBox.setEnabled(enabled);
        this.myComboBox.setEditable(enabled);
        if (enabled) {
            this.setRecents();
            this.updateEditor(this.myItem);
        } else {
            this.myItem = (TextWithImports)this.myComboBox.getEditor().getItem();
            this.myComboBox.removeAllItems();
            this.myComboBox.addItem((Object)this.myItem);
        }
    }

    @Override
    public TextWithImports createText(String text, String importsString) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text, importsString);
    }

    private void addRecents(List<TextWithImports> expressions) {
        for (TextWithImports text : expressions) {
            this.myComboBox.addItem((Object)text);
        }
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
    }

    public DebuggerExpressionComboBox(Project project, @NonNls String recentsId) {
        this(project, null, recentsId, DefaultCodeFragmentFactory.getInstance());
    }

    public DebuggerExpressionComboBox(Project project, PsiElement context, @NonNls String recentsId, CodeFragmentFactory factory) {
        super(project, context, recentsId, factory);
        this.myComboBox.setLightWeightPopupEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myComboBox);
        this.setText(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, ""));
        this.myItem = this.createText("");
        this.setEnabled(true);
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myComboBox.getEditor().getEditorComponent();
    }

    public void selectAll() {
        this.myComboBox.getEditor().selectAll();
    }

    public Editor getEditor() {
        return this.myEditor.getEditor();
    }

    public JComponent getEditorComponent() {
        return (JComponent)this.myEditor.getEditorComponent();
    }

    @Override
    public void addRecent(TextWithImports text) {
        super.addRecent(text);
        this.setRecents();
    }

    private class MyEditorComboBoxEditor
    extends EditorComboBoxEditor {
        public MyEditorComboBoxEditor(Project project, FileType fileType) {
            super(project, fileType);
        }

        @Override
        public Object getItem() {
            Document document = (Document)super.getItem();
            return DebuggerExpressionComboBox.this.createItem(document, DebuggerExpressionComboBox.this.getProject());
        }

        @Override
        public void setItem(Object item) {
            super.setItem(DebuggerExpressionComboBox.this.createDocument((TextWithImports)item));
        }
    }
}

