/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.EditorEvaluationCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeTypeEvaluator
extends EditorEvaluationCommand<String> {
    public RuntimeTypeEvaluator(@Nullable Editor editor, PsiElement expression, DebuggerContextImpl context, ProgressIndicator indicator) {
        super(editor, expression, context, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadAction() {
        String type = null;
        try {
            type = (String)this.evaluate();
        }
        catch (ProcessCanceledException ignored) {
        }
        catch (EvaluateException evaluateException) {
        }
        finally {
            this.typeCalculationFinished(type);
        }
    }

    protected abstract void typeCalculationFinished(@Nullable String var1);

    @Override
    protected String evaluate(final EvaluationContextImpl evaluationContext) throws EvaluateException {
        final Project project = evaluationContext.getProject();
        ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project, new EvaluatingComputable<ExpressionEvaluator>(){

            @Override
            public ExpressionEvaluator compute() throws EvaluateException {
                return EvaluatorBuilderImpl.getInstance().build(RuntimeTypeEvaluator.this.myElement, ContextUtil.getSourcePosition((StackFrameContext)evaluationContext));
            }
        });
        final Value value = evaluator.evaluate(evaluationContext);
        if (value != null) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return DebuggerUtilsEx.getQualifiedClassName(value.type().name(), project);
                }
            });
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.surrounded.expression.null", (Object[])new Object[0]));
    }

    public static boolean isSubtypeable(PsiExpression expr) {
        PsiClass psiClass;
        PsiType type = expr.getType();
        if (type instanceof PsiPrimitiveType) {
            return false;
        }
        return !(type instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null || !psiClass.hasModifierProperty("final");
    }
}

