/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.ui.tree.ValueMarkup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectMarkupPropertiesDialog
extends DialogWrapper {
    private final JTextField myTextMarkupField;
    private final JCheckBox myCbMarkAdditionalFields;
    private final SimpleColoredComponent myColorSample;
    private SimpleTextAttributes myAttributes;
    private final Alarm myUpdateAlarm;
    private static final int UPDATE_DELAY = 200;
    private static Boolean ourMarkCbSavedState;
    private final boolean mySuggestAdditionalMarkup;

    public ObjectMarkupPropertiesDialog(final @NotNull ValueMarkup suggestion, boolean suggestAdditionalMarkup) {
        if (suggestion == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/ObjectMarkupPropertiesDialog.<init> must not be null");
        }
        super(true);
        this.mySuggestAdditionalMarkup = suggestAdditionalMarkup;
        this.setTitle("Select object label");
        this.setModal(true);
        this.myTextMarkupField = new JTextField(30);
        this.myCbMarkAdditionalFields = new JCheckBox("Mark values referenced from constant fields", ourMarkCbSavedState == null ? suggestAdditionalMarkup : ourMarkCbSavedState);
        this.myCbMarkAdditionalFields.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ourMarkCbSavedState = ObjectMarkupPropertiesDialog.this.myCbMarkAdditionalFields.isSelected();
            }
        });
        this.myColorSample = new SimpleColoredComponent();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myAttributes = ObjectMarkupPropertiesDialog.createAttributes(suggestion.getColor());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ObjectMarkupPropertiesDialog.this.myTextMarkupField.setText(suggestion.getText().trim());
                ObjectMarkupPropertiesDialog.this.updateLabelSample(0);
            }
        });
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTextMarkupField;
    }

    protected void dispose() {
        this.myUpdateAlarm.dispose();
        super.dispose();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)new JLabel("Label:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.myTextMarkupField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel samplePanel = new JPanel(new BorderLayout());
        samplePanel.add((Component)this.myColorSample, "Center");
        samplePanel.setBorder(BorderFactory.createEtchedBorder());
        FixedSizeButton chooseColorButton = new FixedSizeButton((JComponent)samplePanel);
        double weighty = this.mySuggestAdditionalMarkup ? 0.0 : 1.0;
        mainPanel.add((Component)new JLabel("Preview: "), new GridBagConstraints(0, -1, 1, 1, 0.0, weighty, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        mainPanel.add((Component)samplePanel, new GridBagConstraints(1, -1, 1, 1, 1.0, weighty, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        mainPanel.add((Component)chooseColorButton, new GridBagConstraints(2, -1, 1, 1, 0.0, weighty, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        if (this.mySuggestAdditionalMarkup) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new MultiLineLabel("If the value is referenced by a constant field of an abstract class,\nIDEA could additionally mark all values referenced from this class with the names of referencing fields."), "Center");
            panel.add((Component)this.myCbMarkAdditionalFields, "South");
            this.myCbMarkAdditionalFields.setMnemonic('M');
            mainPanel.add((Component)panel, new GridBagConstraints(0, -1, 3, 1, 0.0, 1.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        }
        this.myTextMarkupField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ObjectMarkupPropertiesDialog.this.updateLabelSample(200);
            }
        });
        chooseColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = ColorChooser.chooseColor((Component)ObjectMarkupPropertiesDialog.this.myColorSample, (String)"Choose label color", null);
                ObjectMarkupPropertiesDialog.this.myAttributes = ObjectMarkupPropertiesDialog.createAttributes(color);
                ObjectMarkupPropertiesDialog.this.updateLabelSample(200);
            }
        });
        return mainPanel;
    }

    private void updateLabelSample(int updateDelay) {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ObjectMarkupPropertiesDialog.this.myColorSample.clear();
                ObjectMarkupPropertiesDialog.this.myColorSample.append(ObjectMarkupPropertiesDialog.this.myTextMarkupField.getText().trim(), ObjectMarkupPropertiesDialog.this.myAttributes);
                ObjectMarkupPropertiesDialog.this.myColorSample.repaint();
            }
        }, updateDelay);
    }

    public static Pair<ValueMarkup, Boolean> chooseMarkup(ValueMarkup suggestion, boolean suggestAdditionalMarkup) {
        ObjectMarkupPropertiesDialog dialog = new ObjectMarkupPropertiesDialog(suggestion, suggestAdditionalMarkup);
        dialog.show();
        if (dialog.isOK()) {
            String text = dialog.myTextMarkupField.getText().trim();
            Color color = dialog.myAttributes.getFgColor();
            return text.length() > 0 ? new Pair((Object)new ValueMarkup(text, color, suggestion.getToolTipText()), (Object)dialog.myCbMarkAdditionalFields.isSelected()) : null;
        }
        return null;
    }

    private static SimpleTextAttributes createAttributes(Color color) {
        return new SimpleTextAttributes(1, color);
    }
}

