/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ObjectMarkupPropertiesDialog;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.ValueMarkup;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class MarkObjectAction
extends DebuggerAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.actions.MarkObjectAction");
    private final String MARK_TEXT = ActionsBundle.message((String)"action.Debugger.MarkObject.text", (Object[])new Object[0]);
    private final String UNMARK_TEXT = ActionsBundle.message((String)"action.Debugger.MarkObject.unmark.text", (Object[])new Object[0]);

    public void actionPerformed(AnActionEvent event) {
        final DebuggerTreeNodeImpl node = MarkObjectAction.getSelectedNode(event.getDataContext());
        if (node == null) {
            return;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptorImpl)) {
            return;
        }
        final DebuggerTree tree = node.getTree();
        tree.saveState(node);
        final ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
        final DebuggerContextImpl debuggerContext = tree.getDebuggerContext();
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        final ValueMarkup markup = valueDescriptor.getMarkup(debugProcess);
        debugProcess.getManagerThread().invoke(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadAction() {
                boolean _sessionRefreshNeeded;
                boolean sessionRefreshNeeded = true;
                try {
                    if (markup != null) {
                        valueDescriptor.setMarkup(debugProcess, null);
                    } else {
                        final ValueMarkup suggestedMarkup = new ValueMarkup(valueDescriptor.getName(), Color.RED);
                        final Ref result = new Ref(null);
                        try {
                            final boolean suggestAdditionalMarkup = MarkObjectAction.canSuggestAdditionalMarkup(debugProcess, valueDescriptor.getValue());
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    result.set(ObjectMarkupPropertiesDialog.chooseMarkup(suggestedMarkup, suggestAdditionalMarkup));
                                }
                            });
                        }
                        catch (InterruptedException ignored) {
                        }
                        catch (InvocationTargetException e) {
                            LOG.error((Throwable)e);
                        }
                        Pair pair = (Pair)result.get();
                        if (pair != null) {
                            Map<Long, ValueMarkup> map;
                            Value value;
                            Map additionalMarkup;
                            valueDescriptor.setMarkup(debugProcess, (ValueMarkup)pair.first);
                            if (((Boolean)pair.second).booleanValue() && !(additionalMarkup = MarkObjectAction.suggestMarkup((ObjectReference)(value = valueDescriptor.getValue()))).isEmpty() && (map = NodeDescriptorImpl.getMarkupMap(debugProcess)) != null) {
                                for (Map.Entry entry : additionalMarkup.entrySet()) {
                                    Long key = (Long)entry.getKey();
                                    if (map.containsKey(key)) continue;
                                    map.put(key, (ValueMarkup)entry.getValue());
                                }
                            }
                        } else {
                            sessionRefreshNeeded = false;
                        }
                    }
                    _sessionRefreshNeeded = sessionRefreshNeeded;
                }
                catch (Throwable throwable) {
                    boolean _sessionRefreshNeeded2 = sessionRefreshNeeded;
                    SwingUtilities.invokeLater(new Runnable(_sessionRefreshNeeded2){
                        final /* synthetic */ boolean val$_sessionRefreshNeeded;
                        {
                            this.val$_sessionRefreshNeeded = bl;
                        }

                        @Override
                        public void run() {
                            DebuggerSession session;
                            tree.restoreState(node);
                            node.labelChanged();
                            if (this.val$_sessionRefreshNeeded && (session = debuggerContext.getDebuggerSession()) != null) {
                                session.refresh(true);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private static boolean canSuggestAdditionalMarkup(DebugProcessImpl debugProcess, Value value) {
        if (!debugProcess.getVirtualMachineProxy().canGetInstanceInfo()) {
            return false;
        }
        if (!(value instanceof ObjectReference)) {
            return false;
        }
        ObjectReference objRef = (ObjectReference)value;
        return !(objRef instanceof ArrayReference) && !(objRef instanceof ClassObjectReference) && !(objRef instanceof ThreadReference) && !(objRef instanceof ThreadGroupReference) && !(objRef instanceof ClassLoaderReference);
    }

    private static Map<Long, ValueMarkup> suggestMarkup(ObjectReference objRef) {
        HashMap result = new HashMap();
        for (ObjectReference ref : MarkObjectAction.getReferringObjects(objRef)) {
            ReferenceType refType;
            if (!(ref instanceof ClassObjectReference) || !(refType = ((ClassObjectReference)ref).reflectedType()).isAbstract()) continue;
            for (Field field : refType.visibleFields()) {
                Value fieldValue;
                if (!field.isStatic() || !field.isFinal() || DebuggerUtils.isPrimitiveType((String)field.typeName()) || !((fieldValue = refType.getValue(field)) instanceof ObjectReference)) continue;
                long id = ((ObjectReference)fieldValue).uniqueID();
                ValueMarkup markup = (ValueMarkup)result.get(id);
                String fieldName = field.name();
                Color autoMarkupColor = ValueMarkup.getAutoMarkupColor();
                if (markup == null) {
                    result.put(id, new ValueMarkup(fieldName, autoMarkupColor, MarkObjectAction.createMarkupTooltipText(null, refType, fieldName)));
                    continue;
                }
                String currentText = markup.getText();
                if (currentText.contains(fieldName)) continue;
                String currentTooltip = markup.getToolTipText();
                String tooltip = MarkObjectAction.createMarkupTooltipText(currentTooltip, refType, fieldName);
                result.put(id, new ValueMarkup(currentText + ", " + fieldName, autoMarkupColor, tooltip));
            }
        }
        return result;
    }

    private static List<ObjectReference> getReferringObjects(ObjectReference value) {
        try {
            Method apiMethod = ObjectReference.class.getMethod("referringObjects", Long.TYPE);
            return (List)apiMethod.invoke((Object)value, 100L);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static String createMarkupTooltipText(String prefix, ReferenceType refType, String fieldName) {
        StringBuilder builder = new StringBuilder();
        if (prefix == null) {
            builder.append("Value referenced from:");
        } else {
            builder.append(prefix);
        }
        return builder.append("<br><b>").append(refType.name()).append(".").append(fieldName).append("</b>").toString();
    }

    public void update(AnActionEvent e) {
        ValueMarkup markup;
        NodeDescriptorImpl descriptor;
        boolean enable = false;
        String text = this.MARK_TEXT;
        DebuggerTreeNodeImpl node = MarkObjectAction.getSelectedNode(e.getDataContext());
        if (node != null && (enable = (descriptor = node.getDescriptor()) instanceof ValueDescriptor) && (markup = ((ValueDescriptor)((Object)descriptor)).getMarkup(node.getTree().getDebuggerContext().getDebugProcess())) != null) {
            text = this.UNMARK_TEXT;
        }
        Presentation presentation = e.getPresentation();
        presentation.setVisible(enable);
        presentation.setText(text);
    }
}

