/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SettingsXmlFile {
    private final File myFile;
    private final Document myDocument;
    private final Element myRootElement;

    SettingsXmlFile(@NotNull File file) throws CannotConvertException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/SettingsXmlFile.<init> must not be null");
        }
        this.myFile = file;
        this.myDocument = JDomConvertingUtil.loadDocument(file);
        this.myRootElement = this.myDocument.getRootElement();
    }

    public File getFile() {
        return this.myFile;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public Element getRootElement() {
        return this.myRootElement;
    }

    public void save() throws IOException {
        JDOMUtil.writeDocument((Document)this.myDocument, (File)this.myFile, (String)SystemProperties.getLineSeparator());
    }

    @Nullable
    public Element findComponent(String componentName) {
        return JDomConvertingUtil.findComponent(this.myRootElement, componentName);
    }
}

