/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import java.io.File;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ComponentManagerSettingsImpl
implements ComponentManagerSettings {
    protected final SettingsXmlFile mySettingsFile;
    protected final ConversionContextImpl myContext;

    protected ComponentManagerSettingsImpl(File file, ConversionContextImpl context) throws CannotConvertException {
        this.myContext = context;
        this.mySettingsFile = context.getOrCreateFile(file);
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.mySettingsFile.getDocument();
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ComponentManagerSettingsImpl.getDocument must not return null");
        }
        return document;
    }

    @Override
    @NotNull
    public Element getRootElement() {
        Element element = this.mySettingsFile.getRootElement();
        if (element == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ComponentManagerSettingsImpl.getRootElement must not return null");
        }
        return element;
    }

    @Override
    public Element getComponentElement(@NotNull @NonNls String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ComponentManagerSettingsImpl.getComponentElement must not be null");
        }
        return this.mySettingsFile.findComponent(componentName);
    }

    @Override
    public File getFile() {
        return this.mySettingsFile.getFile();
    }
}

