/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class JavaCompilersTab
implements SearchableConfigurable {
    private JPanel myPanel;
    private JPanel myContentPanel;
    private JComboBox myCompiler;
    private final CardLayout myCardLayout;
    private final BackendCompiler myDefaultCompiler;
    private BackendCompiler mySelectedCompiler;
    private final CompilerConfigurationImpl myCompilerConfiguration;
    private final Collection<Configurable> myConfigurables;

    public JavaCompilersTab(Project project, Collection<BackendCompiler> compilers, BackendCompiler defaultCompiler) {
        this.myDefaultCompiler = defaultCompiler;
        this.$$$setupUI$$$();
        this.myCompilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        this.myConfigurables = new ArrayList<Configurable>(compilers.size());
        this.myCardLayout = new CardLayout();
        this.myContentPanel.setLayout(this.myCardLayout);
        for (BackendCompiler compiler : compilers) {
            Configurable configurable = compiler.createConfigurable();
            this.myConfigurables.add(configurable);
            this.myContentPanel.add((Component)configurable.createComponent(), compiler.getId());
        }
        this.myCompiler.setModel(new DefaultComboBoxModel<BackendCompiler>(new Vector<BackendCompiler>(compilers)));
        this.myCompiler.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String presentableName = value != null ? ((BackendCompiler)value).getPresentableName() : "";
                component.setText(presentableName);
                return component;
            }
        });
        this.myCompiler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BackendCompiler compiler = (BackendCompiler)JavaCompilersTab.this.myCompiler.getSelectedItem();
                if (compiler == null) {
                    return;
                }
                JavaCompilersTab.this.selectCompiler(compiler);
            }
        });
    }

    public String getDisplayName() {
        return CompilerBundle.message((String)"java.compiler.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.javacompiler";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        if (!Comparing.equal((Object)this.mySelectedCompiler, (Object)this.myCompilerConfiguration.getDefaultCompiler())) {
            return true;
        }
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable configurable : this.myConfigurables) {
            configurable.apply();
        }
        this.myCompilerConfiguration.setDefaultCompiler(this.mySelectedCompiler);
    }

    public void reset() {
        for (Configurable configurable : this.myConfigurables) {
            configurable.reset();
        }
        this.selectCompiler(this.myCompilerConfiguration.getDefaultCompiler());
    }

    public void disposeUIResources() {
    }

    private void selectCompiler(BackendCompiler compiler) {
        if (compiler == null) {
            compiler = this.myDefaultCompiler;
        }
        this.myCompiler.setSelectedItem(compiler);
        this.mySelectedCompiler = compiler;
        this.myCardLayout.show(this.myContentPanel, compiler.getId());
        this.myContentPanel.revalidate();
        this.myContentPanel.repaint();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(15, 7, 3, 7), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("option.use.compiler.text"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompiler = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myContentPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

