/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.ExternalCompiler;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfigurable;
import com.intellij.compiler.impl.javaCompiler.javac.JavacOutputParser;
import com.intellij.compiler.impl.javaCompiler.javac.JavacSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.MockJdkWrapper;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.rt.compiler.JavacRunner;
import com.intellij.util.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavacCompiler
extends ExternalCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler");
    private final Project myProject;
    private final List<File> myTempFiles = new ArrayList<File>();
    @NonNls
    private static final String JAVAC_MAIN_CLASS_OLD = "sun.tools.javac.Main";
    @NonNls
    public static final String JAVAC_MAIN_CLASS = "com.sun.tools.javac.Main";
    private boolean myAnnotationProcessorMode = false;

    public JavacCompiler(Project project) {
        this.myProject = project;
    }

    public boolean isAnnotationProcessorMode() {
        return this.myAnnotationProcessorMode;
    }

    public boolean setAnnotationProcessorMode(boolean annotationProcessorMode) {
        boolean oldValue = this.myAnnotationProcessorMode;
        this.myAnnotationProcessorMode = annotationProcessorMode;
        return oldValue;
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        Module[] modules = scope.getAffectedModules();
        HashSet<Sdk> checkedJdks = new HashSet<Sdk>();
        for (Module module : modules) {
            Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (jdk == null || checkedJdks.contains(jdk)) continue;
            VirtualFile homeDirectory = jdk.getHomeDirectory();
            if (homeDirectory == null) {
                Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.jdkHomeNotFoundMessage((Sdk)jdk), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return false;
            }
            SdkType sdkType = jdk.getSdkType();
            if (sdkType instanceof JavaSdkType) {
                String vmExecutablePath = ((JavaSdkType)sdkType).getVMExecutablePath(jdk);
                if (vmExecutablePath == null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.vm.executable.missing", (Object[])new Object[]{jdk.getName()}), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                String toolsJarPath = ((JavaSdkType)sdkType).getToolsPath(jdk);
                if (toolsJarPath == null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.tools.jar.missing", (Object[])new Object[]{jdk.getName()}), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                String versionString = jdk.getVersionString();
                if (versionString == null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.unknown.jdk.version", (Object[])new Object[]{jdk.getName()}), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                if (CompilerUtil.isOfVersion(versionString, "1.0")) {
                    Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.1_0_compilation.not.supported", (Object[])new Object[0]), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
            }
            checkedJdks.add(jdk);
        }
        return true;
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        if ("Javac" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler.getId must not return null");
        }
        return "Javac";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler.getPresentableName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        JavacConfigurable javacConfigurable = new JavacConfigurable(JavacSettings.getInstance(this.myProject));
        if (javacConfigurable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler.createConfigurable must not return null");
        }
        return javacConfigurable;
    }

    @Override
    public OutputParser createErrorParser(@NotNull String outputDir, Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler.createErrorParser must not be null");
        }
        return new JavacOutputParser(this.myProject);
    }

    @Override
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler.createOutputParser must not be null");
        }
        return null;
    }

    @Override
    @NotNull
    public String[] createStartupCommand(final ModuleChunk chunk, CompileContext context, final String outputPath) throws IOException, IllegalArgumentException {
        String[] stringArray;
        try {
            stringArray = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

                public String[] compute() {
                    try {
                        ArrayList commandLine = new ArrayList();
                        JavacCompiler.this.createStartupCommand(chunk, commandLine, outputPath, JavacSettings.getInstance(JavacCompiler.this.myProject));
                        return ArrayUtil.toStringArray(commandLine);
                    }
                    catch (IOException e) {
                        throw new MyException(e);
                    }
                }
            });
        }
        catch (MyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler.createStartupCommand must not return null");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStartupCommand(ModuleChunk chunk, @NonNls List<String> commandLine, String outputPath, JavacSettings javacSettings) throws IOException {
        boolean isVersion1_5_or_higher;
        Sdk jdk = this.getJdkForStartupCommand(chunk);
        String versionString = jdk.getVersionString();
        if (versionString == null || "".equals(versionString) || !(jdk.getSdkType() instanceof JavaSdkType)) {
            throw new IllegalArgumentException(CompilerBundle.message((String)"javac.error.unknown.jdk.version", (Object[])new Object[]{jdk.getName()}));
        }
        boolean isVersion1_0 = CompilerUtil.isOfVersion(versionString, "1.0");
        boolean isVersion1_1 = CompilerUtil.isOfVersion(versionString, "1.1");
        boolean isVersion1_2 = CompilerUtil.isOfVersion(versionString, "1.2");
        boolean isVersion1_3 = CompilerUtil.isOfVersion(versionString, "1.3");
        boolean isVersion1_4 = CompilerUtil.isOfVersion(versionString, "1.4");
        boolean isVersion1_5 = CompilerUtil.isOfVersion(versionString, "1.5") || CompilerUtil.isOfVersion(versionString, "5.0");
        boolean bl = isVersion1_5_or_higher = isVersion1_5 || !isVersion1_0 && !isVersion1_1 && !isVersion1_2 && !isVersion1_3 && !isVersion1_4;
        int versionIndex = isVersion1_0 ? 0 : (isVersion1_1 ? 1 : (isVersion1_2 ? 2 : (isVersion1_3 ? 3 : (isVersion1_4 ? 4 : (isVersion1_5 ? 5 : 6)))));
        JavaSdkType sdkType = (JavaSdkType)jdk.getSdkType();
        String toolsJarPath = sdkType.getToolsPath(jdk);
        if (toolsJarPath == null) {
            throw new IllegalArgumentException(CompilerBundle.message((String)"javac.error.tools.jar.missing", (Object[])new Object[]{jdk.getName()}));
        }
        String vmExePath = sdkType.getVMExecutablePath(jdk);
        commandLine.add(vmExePath);
        if (isVersion1_1 || isVersion1_0) {
            commandLine.add("-mx" + javacSettings.MAXIMUM_HEAP_SIZE + "m");
        } else {
            commandLine.add("-Xmx" + javacSettings.MAXIMUM_HEAP_SIZE + "m");
        }
        List<String> additionalOptions = JavacCompiler.addAdditionalSettings(commandLine, javacSettings, this.myAnnotationProcessorMode, versionIndex, this.myProject);
        CompilerUtil.addLocaleOptions(commandLine, false);
        commandLine.add("-classpath");
        if (isVersion1_0) {
            commandLine.add(sdkType.getToolsPath(jdk));
        } else {
            commandLine.add(sdkType.getToolsPath(jdk) + File.pathSeparator + JavaSdkUtil.getIdeaRtJarPath());
            commandLine.add(JavacRunner.class.getName());
            commandLine.add("\"" + versionString + "\"");
        }
        if (isVersion1_2 || isVersion1_1 || isVersion1_0) {
            commandLine.add(JAVAC_MAIN_CLASS_OLD);
        } else {
            commandLine.add(JAVAC_MAIN_CLASS);
        }
        JavacCompiler.addCommandLineOptions(chunk, commandLine, outputPath, jdk, isVersion1_0, isVersion1_1, this.myTempFiles, true, true, this.myAnnotationProcessorMode);
        commandLine.addAll(additionalOptions);
        List<VirtualFile> files = chunk.getFilesToCompile();
        if (isVersion1_0) {
            for (VirtualFile file : files) {
                String path = file.getPath();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding path for compilation " + path);
                }
                commandLine.add(CompilerUtil.quotePath(path));
            }
        } else {
            File sourcesFile = FileUtil.createTempFile((String)"javac", (String)".tmp");
            sourcesFile.deleteOnExit();
            this.myTempFiles.add(sourcesFile);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(sourcesFile)));
            try {
                for (VirtualFile file : files) {
                    String path;
                    String string = path = isVersion1_5_or_higher ? file.getPath().replace('/', File.separatorChar) : file.getPath();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding path for compilation " + path);
                    }
                    writer.println(isVersion1_1 ? path : CompilerUtil.quotePath(path));
                }
            }
            finally {
                writer.close();
            }
            commandLine.add("@" + sourcesFile.getAbsolutePath());
        }
    }

    public static List<String> addAdditionalSettings(List<String> commandLine, JavacSettings javacSettings, boolean isAnnotationProcessing, int versionIndex, Project project) {
        ArrayList<String> additionalOptions = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(javacSettings.getOptionsString(project), " ");
        if (versionIndex < 6) {
            isAnnotationProcessing = false;
        }
        if (isAnnotationProcessing) {
            String processorPath;
            CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project);
            additionalOptions.add("-Xprefer:source");
            additionalOptions.add("-implicit:none");
            additionalOptions.add("-proc:only");
            if (!config.isObtainProcessorsFromClasspath() && (processorPath = config.getProcessorPath()).length() > 0) {
                additionalOptions.add("-processorpath");
                additionalOptions.add(FileUtil.toSystemDependentName((String)processorPath));
            }
            for (Map.Entry entry : config.getAnnotationProcessorsMap().entrySet()) {
                additionalOptions.add("-processor");
                additionalOptions.add((String)entry.getKey());
                String options = (String)entry.getValue();
                if (options.length() <= 0) continue;
                StringTokenizer optionsTokenizer = new StringTokenizer(options, " ", false);
                while (optionsTokenizer.hasMoreTokens()) {
                    String token = optionsTokenizer.nextToken();
                    if (token.startsWith("-A")) {
                        additionalOptions.add(token.substring("-A".length()));
                        continue;
                    }
                    additionalOptions.add("-A" + token);
                }
            }
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (versionIndex == 0 && "-deprecation".equals(token) || versionIndex <= 4 && "-Xlint".equals(token) || isAnnotationProcessing && (token.startsWith("-proc:") || token.startsWith("-implicit:"))) continue;
            if (token.startsWith("-J-")) {
                commandLine.add(token.substring("-J".length()));
                continue;
            }
            additionalOptions.add(token);
        }
        return additionalOptions;
    }

    public static void addCommandLineOptions(ModuleChunk chunk, @NonNls List<String> commandLine, String outputPath, Sdk jdk, boolean version1_0, boolean version1_1, List<File> tempFiles, boolean addSourcePath, boolean useTempFile, boolean isAnnotationProcessingMode) throws IOException {
        String classPath;
        LanguageLevel languageLevel = chunk.getLanguageLevel();
        CompilerUtil.addSourceCommandLineSwitch(jdk, languageLevel, commandLine);
        commandLine.add("-verbose");
        String cp = chunk.getCompilationClasspath();
        String bootCp = chunk.getCompilationBootClasspath();
        if (version1_0 || version1_1) {
            classPath = bootCp + File.pathSeparator + cp;
        } else {
            classPath = cp;
            commandLine.add("-bootclasspath");
            JavacCompiler.addClassPathValue(jdk, false, commandLine, bootCp, "javac_bootcp", tempFiles, useTempFile);
        }
        commandLine.add("-classpath");
        JavacCompiler.addClassPathValue(jdk, version1_0, commandLine, classPath, "javac_cp", tempFiles, useTempFile);
        if (!version1_1 && !version1_0 && addSourcePath) {
            commandLine.add("-sourcepath");
            commandLine.add("\"\"");
        }
        if (isAnnotationProcessingMode) {
            commandLine.add("-s");
            commandLine.add(outputPath.replace('/', File.separatorChar));
            String moduleOutputPath = CompilerPaths.getModuleOutputPath((Module)chunk.getModules()[0], (boolean)false);
            if (moduleOutputPath != null) {
                commandLine.add("-d");
                commandLine.add(moduleOutputPath.replace('/', File.separatorChar));
            }
        } else {
            commandLine.add("-d");
            commandLine.add(outputPath.replace('/', File.separatorChar));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addClassPathValue(Sdk jdk, boolean isVersion1_0, List<String> commandLine, String cpString, @NonNls String tempFileName, List<File> tempFiles, boolean useTempFile) throws IOException {
        if (!useTempFile) {
            commandLine.add(cpString);
            return;
        }
        if (isVersion1_0) {
            commandLine.add(((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk) + File.pathSeparator + cpString);
        } else {
            File cpFile = FileUtil.createTempFile((String)tempFileName, (String)".tmp");
            cpFile.deleteOnExit();
            tempFiles.add(cpFile);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cpFile)));
            try {
                CompilerIOUtil.writeString(cpString, out);
            }
            finally {
                out.close();
            }
            commandLine.add("@" + cpFile.getAbsolutePath());
        }
    }

    private Sdk getJdkForStartupCommand(ModuleChunk chunk) {
        Sdk jdk = chunk.getJdk();
        if (ApplicationManager.getApplication().isUnitTestMode() && JavacSettings.getInstance(this.myProject).isTestsUseExternalCompiler()) {
            String jdkHomePath = CompilerConfigurationImpl.getTestsExternalCompilerHome();
            if (jdkHomePath == null) {
                throw new IllegalArgumentException("[TEST-MODE] Cannot determine home directory for JDK to use javac from");
            }
            return new MockJdkWrapper(jdkHomePath, jdk);
        }
        return jdk;
    }

    @Override
    public void compileFinished() {
        FileUtil.asyncDelete(this.myTempFiles);
        this.myTempFiles.clear();
    }

    private static class MyException
    extends RuntimeException {
        private MyException(Throwable cause) {
            super(cause);
        }
    }
}

