/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.packaging.impl.ui.ChooseArtifactsDialog;
import java.util.ArrayList;
import java.util.List;

public class BuildArtifactAction
extends AnAction {
    public BuildArtifactAction() {
        super("Build Artifact");
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (project == null) {
            return;
        }
        List<Artifact> artifacts = BuildArtifactAction.getArtifactWithOutputPaths(project);
        if (artifacts.isEmpty()) {
            return;
        }
        presentation.setEnabled(true);
        if (artifacts.size() == 1) {
            presentation.setText("Build '" + StringUtil.first((String)artifacts.get(0).getName(), (int)40, (boolean)true) + "' artifact");
        } else {
            presentation.setText("Build Artifacts...");
        }
    }

    private static List<Artifact> getArtifactWithOutputPaths(Project project) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getSortedArtifacts()) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            result.add(artifact);
        }
        return result;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        List<Artifact> artifacts = BuildArtifactAction.getArtifactWithOutputPaths(project);
        if (artifacts.isEmpty()) {
            return;
        }
        if (artifacts.size() == 1) {
            BuildArtifactAction.buildArtifacts(project, artifacts);
            return;
        }
        ChooseArtifactsDialog dialog = new ChooseArtifactsDialog(project, (List<? extends Artifact>)artifacts, "Choose Artifacts to Build", "Selected artifacts will be built with all dependencies");
        List<Artifact> initialSelection = ArtifactsWorkspaceSettings.getInstance(project).getArtifactsToBuild();
        if (!initialSelection.isEmpty()) {
            dialog.selectElements(initialSelection);
        }
        dialog.show();
        if (dialog.isOK()) {
            List<Artifact> selected = dialog.getChosenElements();
            ArtifactsWorkspaceSettings.getInstance(project).setArtifactsToBuild(selected);
            BuildArtifactAction.buildArtifacts(project, selected);
        }
    }

    private static void buildArtifacts(Project project, List<Artifact> artifacts) {
        CompilerManager.getInstance((Project)project).make(ArtifactCompileScope.createArtifactsScope(project, artifacts), null);
    }
}

