/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.htmlInspections.RemoveExtraClosingTagIntentionAction;
import com.intellij.codeInspection.htmlInspections.RenameTagBeginOrEndIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlWrongClosingTagNameInspection
implements Annotator {
    public void annotate(PsiElement psiElement, AnnotationHolder holder) {
        if (psiElement instanceof XmlToken) {
            String message;
            PsiFile psiFile;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof XmlTag) {
                PsiErrorElement errorElement;
                XmlTag tag = (XmlTag)parent;
                XmlToken start = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
                if (endTagName != null && !(tag instanceof HtmlTag) && !tag.getName().equals(endTagName.getText())) {
                    XmlWrongClosingTagNameInspection.registerProblem(holder, tag, start, endTagName);
                } else if (!(endTagName != null || tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag.getName()) || (endTagName = XmlWrongClosingTagNameInspection.findEndTagName(errorElement = (PsiErrorElement)PsiTreeUtil.getChildOfType((PsiElement)tag, PsiErrorElement.class))) == null)) {
                    XmlWrongClosingTagNameInspection.registerProblem(holder, tag, start, endTagName);
                }
            } else if (parent instanceof PsiErrorElement && XmlTokenType.XML_NAME == ((XmlToken)psiElement).getTokenType() && (psiFile = psiElement.getContainingFile()) != null && (HTMLLanguage.INSTANCE == psiFile.getViewProvider().getBaseLanguage() || HTMLLanguage.INSTANCE == parent.getLanguage()) && (message = XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0])).equals(((PsiErrorElement)parent).getErrorDescription()) && psiFile.getContext() == null) {
                Annotation annotation = holder.createWarningAnnotation(parent, message);
                annotation.registerFix((IntentionAction)new RemoveExtraClosingTagIntentionAction());
            }
        }
    }

    private static void registerProblem(@NotNull AnnotationHolder holder, @NotNull XmlTag tag, @Nullable XmlToken start, @NotNull XmlToken end) {
        Annotation annotation;
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection.registerProblem must not be null");
        }
        if (tag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection.registerProblem must not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection.registerProblem must not be null");
        }
        String tagName = tag instanceof HtmlTag ? tag.getName().toLowerCase() : tag.getName();
        String endTokenText = tag instanceof HtmlTag ? end.getText().toLowerCase() : end.getText();
        RenameTagBeginOrEndIntentionAction renameEndAction = new RenameTagBeginOrEndIntentionAction(tagName, endTokenText, false);
        RenameTagBeginOrEndIntentionAction renameStartAction = new RenameTagBeginOrEndIntentionAction(endTokenText, tagName, true);
        if (start != null) {
            annotation = holder.createErrorAnnotation((PsiElement)start, XmlErrorMessages.message("tag.has.wrong.closing.tag.name", new Object[0]));
            annotation.registerFix((IntentionAction)renameEndAction);
            annotation.registerFix((IntentionAction)renameStartAction);
        }
        annotation = holder.createErrorAnnotation((PsiElement)end, XmlErrorMessages.message("wrong.closing.tag.name", new Object[0]));
        annotation.registerFix((IntentionAction)new RemoveExtraClosingTagIntentionAction());
        annotation.registerFix((IntentionAction)renameEndAction);
        annotation.registerFix((IntentionAction)renameStartAction);
    }

    @Nullable
    static XmlToken findEndTagName(@Nullable PsiErrorElement element) {
        ASTNode current;
        if (element == null) {
            return null;
        }
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return null;
        }
        ASTNode prev = current = astNode.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlElementType.XML_NAME || elementType == XmlElementType.XML_TAG_NAME) && current.getElementType() == XmlElementType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }
}

