/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionManagerEx
extends InspectionManager {
    private GlobalInspectionContextImpl myGlobalInspectionContext = null;
    private final Project myProject;
    @NonNls
    private String myCurrentProfileName;
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();

    public InspectionManagerEx(Project project) {
        this.myProject = project;
        this.myContentManager = !ApplicationManager.getApplication().isHeadlessEnvironment() ? new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)InspectionManagerEx.this.myProject);
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)InspectionManagerEx.this.myProject);
                ContentManager contentManager = toolWindow.getContentManager();
                toolWindow.setIcon(IconLoader.getIcon((String)"/general/toolWindowInspection.png"));
                new ContentManagerWatcher(toolWindow, contentManager);
                ContentManager contentManager2 = contentManager;
                if (contentManager2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx$1.compute must not return null");
                }
                return contentManager2;
            }
        } : new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ContentManager contentManager = ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, InspectionManagerEx.this.myProject);
                if (contentManager == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx$2.compute must not return null");
                }
                return contentManager;
            }
        };
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public CommonProblemDescriptor createProblemDescriptor(@NotNull String descriptionTemplate, QuickFix ... fixes) {
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        CommonProblemDescriptorImpl commonProblemDescriptorImpl = new CommonProblemDescriptorImpl(fixes, descriptionTemplate);
        if (commonProblemDescriptorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return commonProblemDescriptorImpl;
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix fix, ProblemHighlightType highlightType, boolean onTheFly) {
        LocalQuickFix[] localQuickFixArray;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = null;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        ProblemDescriptor problemDescriptor = this.createProblemDescriptor(psiElement, descriptionTemplate, onTheFly, quickFixes, highlightType);
        if (problemDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptor;
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, boolean onTheFly, LocalQuickFix[] fixes, ProblemHighlightType highlightType) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        ProblemDescriptor problemDescriptor = this.createProblemDescriptor(psiElement, descriptionTemplate, fixes, highlightType, onTheFly, false);
        if (problemDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptor;
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, ProblemHighlightType highlightType, boolean onTheFly, boolean isAfterEndOfLine) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, isAfterEndOfLine, null, onTheFly);
        if (problemDescriptorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptorImpl;
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, boolean onTheFly, LocalQuickFix ... fixes) {
        if (startElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (endElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(startElement, endElement, descriptionTemplate, fixes, highlightType, false, null, onTheFly);
        if (problemDescriptorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptorImpl;
    }

    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, TextRange rangeInElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, rangeInElement, onTheFly);
    }

    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
    }

    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, boolean showTooltip, ProblemHighlightType highlightType, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, showTooltip, null, onTheFly);
    }

    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        if (reuse) {
            if (this.myGlobalInspectionContext == null) {
                this.myGlobalInspectionContext = new GlobalInspectionContextImpl(this.myProject, this.myContentManager);
            }
            this.myRunningContexts.add(this.myGlobalInspectionContext);
            return this.myGlobalInspectionContext;
        }
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(this.myProject, this.myContentManager);
        this.myRunningContexts.add(inspectionContext);
        return inspectionContext;
    }

    public void setProfile(String name) {
        this.myCurrentProfileName = name;
    }

    public String getCurrentProfile() {
        if (this.myCurrentProfileName == null) {
            InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(this.myProject);
            this.myCurrentProfileName = profileManager.getProjectProfile();
            if (this.myCurrentProfileName == null) {
                this.myCurrentProfileName = InspectionProfileManager.getInstance().getRootProfile().getName();
            }
        }
        return this.myCurrentProfileName;
    }

    public void closeRunningContext(GlobalInspectionContextImpl globalInspectionContext) {
        this.myRunningContexts.remove(globalInspectionContext);
    }

    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        return this.myRunningContexts;
    }

    public static boolean inspectionResultSuppressed(PsiElement place, LocalInspectionTool tool) {
        if (tool instanceof CustomSuppressableInspectionTool) {
            return ((CustomSuppressableInspectionTool)tool).isSuppressedFor(place);
        }
        return InspectionManagerEx.isSuppressed(place, tool.getID()) || InspectionManagerEx.isSuppressed(place, tool.getAlternativeID());
    }

    public static boolean canRunInspections(Project project, boolean online) {
        for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            if (factory.isProjectConfiguredToRunInspections(project, online)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuppressed(PsiElement psiElement, String id) {
        if (id == null) {
            return false;
        }
        for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            if (factory.isToCheckMember(psiElement, id)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix fix, ProblemHighlightType highlightType) {
        LocalQuickFix[] localQuickFixArray;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = null;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        ProblemDescriptor problemDescriptor = this.createProblemDescriptor(psiElement, descriptionTemplate, quickFixes, highlightType);
        if (problemDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptor;
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, ProblemHighlightType highlightType) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        ProblemDescriptor problemDescriptor = this.createProblemDescriptor(psiElement, descriptionTemplate, fixes, highlightType, false);
        if (problemDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptor;
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, ProblemHighlightType highlightType, boolean isAfterEndOfLine) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, isAfterEndOfLine, null, true);
        if (problemDescriptorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptorImpl;
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (startElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (endElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(startElement, endElement, descriptionTemplate, fixes, highlightType, false, null, true);
        if (problemDescriptorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not return null");
        }
        return problemDescriptorImpl;
    }

    @Deprecated
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, TextRange rangeInElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, rangeInElement, true);
    }

    @Deprecated
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, @Nullable HintAction hintAction, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, true);
    }

    @Deprecated
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, boolean showTooltip, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionManagerEx.createProblemDescriptor must not be null");
        }
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, showTooltip, null, true);
    }
}

