/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;

public class PushInstruction
extends Instruction {
    private final DfaValue myValue;
    private final PsiExpression myPlace;

    public PushInstruction(DfaValue value, PsiExpression place) {
        this.myValue = value != null ? value : DfaUnknownValue.getInstance();
        this.myPlace = place;
    }

    @NotNull
    public DfaValue getValue() {
        DfaValue dfaValue = this.myValue;
        if (dfaValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/instructions/PushInstruction.getValue must not return null");
        }
        return dfaValue;
    }

    public PsiExpression getPlace() {
        return this.myPlace;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitPush(this, runner, stateBefore);
    }

    @Override
    public String toString() {
        return "PUSH " + this.myValue;
    }
}

