/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.canBeFinal;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.canBeFinal.CanBeFinalAnnotator;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanBeFinalInspection
extends GlobalJavaInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.canBeFinal.CanBeFinalInspection");
    public boolean REPORT_CLASSES = false;
    public boolean REPORT_METHODS = false;
    public boolean REPORT_FIELDS = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.can.be.final.display.name", (Object[])new Object[0]);
    @NonNls
    public static final String SHORT_NAME = "CanBeFinal";
    @NonNls
    private static final String QUICK_FIX_NAME = InspectionsBundle.message((String)"inspection.can.be.final.accept.quickfix", (Object[])new Object[0]);

    public boolean isReportClasses() {
        return this.REPORT_CLASSES;
    }

    public boolean isReportMethods() {
        return this.REPORT_METHODS;
    }

    public boolean isReportFields() {
        return this.REPORT_FIELDS;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(RefManager refManager) {
        return new CanBeFinalAnnotator(refManager);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefJavaElement) {
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (refElement instanceof RefParameter) {
                return null;
            }
            if (!refElement.isReferenced()) {
                return null;
            }
            if (refElement.isSyntheticJSP()) {
                return null;
            }
            if (refElement.isFinal()) {
                return null;
            }
            if (!((RefElementImpl)refElement).checkFlag(CanBeFinalAnnotator.CAN_BE_FINAL_MASK)) {
                return null;
            }
            PsiIdentifier psiIdentifier = null;
            if (refElement instanceof RefClass) {
                RefClass refClass = (RefClass)refElement;
                if (refClass.isInterface() || refClass.isAnonymous() || refClass.isAbstract()) {
                    return null;
                }
                if (!this.isReportClasses()) {
                    return null;
                }
                psiIdentifier = refClass.getElement().getNameIdentifier();
            } else if (refElement instanceof RefMethod) {
                RefMethod refMethod = (RefMethod)refElement;
                if (refMethod.getOwnerClass().isFinal()) {
                    return null;
                }
                if (!this.isReportMethods()) {
                    return null;
                }
                psiIdentifier = ((PsiMethod)refMethod.getElement()).getNameIdentifier();
            } else if (refElement instanceof RefField) {
                if (!this.isReportFields()) {
                    return null;
                }
                psiIdentifier = ((RefField)refElement).getElement().getNameIdentifier();
            }
            if (psiIdentifier != null) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiIdentifier, InspectionsBundle.message((String)"inspection.export.results.can.be.final.description", (Object[])new Object[0]), (LocalQuickFix)new AcceptSuggested(globalContext.getRefManager()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, final GlobalJavaInspectionContext globalContext, final ProblemDescriptionsProcessor problemsProcessor) {
        for (RefElement entryPoint : globalContext.getEntryPointsManager(manager).getEntryPoints()) {
            problemsProcessor.ignoreElement((RefEntity)entryPoint);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (problemsProcessor.getDescriptions(refEntity) == null) {
                    return;
                }
                refEntity.accept((RefVisitor)new RefJavaVisitor(){

                    public void visitMethod(final RefMethod refMethod) {
                        if (!(refMethod.isStatic() || "private".equals(refMethod.getAccessModifier()) || refMethod instanceof RefImplicitConstructor)) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    ((RefElementImpl)refMethod).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                    problemsProcessor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    }

                    public void visitClass(final RefClass refClass) {
                        if (!refClass.isAnonymous()) {
                            globalContext.enqueueDerivedClassesProcessor(refClass, new GlobalJavaInspectionContext.DerivedClassesProcessor(){

                                public boolean process(PsiClass inheritor) {
                                    ((RefClassImpl)refClass).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                    problemsProcessor.ignoreElement((RefEntity)refClass);
                                    return false;
                                }
                            });
                        }
                    }

                    public void visitField(final RefField refField) {
                        globalContext.enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                            public boolean process(PsiReference psiReference) {
                                PsiElement expression = psiReference.getElement();
                                if (expression instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression))) {
                                    ((RefFieldImpl)refField).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                    problemsProcessor.ignoreElement((RefEntity)refField);
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                });
            }
        });
        return false;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new AcceptSuggested(null);
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/canBeFinal/CanBeFinalInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/canBeFinal/CanBeFinalInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/canBeFinal/CanBeFinalInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private final RefManager myManager;

        public AcceptSuggested(RefManager manager) {
            this.myManager = manager;
        }

        @NotNull
        public String getName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested.applyFix must not be null");
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{PsiUtilBase.getVirtualFile((PsiElement)descriptor.getPsiElement())}).hasReadonlyFiles()) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            PsiModifierListOwner psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
            if (psiElement != null) {
                RefJavaElement refElement = (RefJavaElement)(this.myManager != null ? this.myManager.getReference((PsiElement)psiElement) : null);
                try {
                    if (psiElement instanceof PsiVariable) {
                        ((PsiVariable)psiElement).normalizeDeclaration();
                    }
                    PsiModifierList modifierList = psiElement.getModifierList();
                    LOG.assertTrue(modifierList != null);
                    modifierList.setModifierProperty("final", true);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (refElement != null) {
                    RefJavaUtil.getInstance().setIsFinal(refElement, true);
                }
            }
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myReportClassesCheckbox;
        private final JCheckBox myReportMethodsCheckbox;
        private final JCheckBox myReportFieldsCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myReportClassesCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.can.be.final.option", (Object[])new Object[0]));
            this.myReportClassesCheckbox.setSelected(CanBeFinalInspection.this.REPORT_CLASSES);
            this.myReportClassesCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CanBeFinalInspection.this.REPORT_CLASSES = OptionsPanel.this.myReportClassesCheckbox.isSelected();
                }
            });
            gc.gridy = 0;
            this.add((Component)this.myReportClassesCheckbox, gc);
            this.myReportMethodsCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.can.be.final.option1", (Object[])new Object[0]));
            this.myReportMethodsCheckbox.setSelected(CanBeFinalInspection.this.REPORT_METHODS);
            this.myReportMethodsCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CanBeFinalInspection.this.REPORT_METHODS = OptionsPanel.this.myReportMethodsCheckbox.isSelected();
                }
            });
            ++gc.gridy;
            this.add((Component)this.myReportMethodsCheckbox, gc);
            this.myReportFieldsCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.can.be.final.option2", (Object[])new Object[0]));
            this.myReportFieldsCheckbox.setSelected(CanBeFinalInspection.this.REPORT_FIELDS);
            this.myReportFieldsCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CanBeFinalInspection.this.REPORT_FIELDS = OptionsPanel.this.myReportFieldsCheckbox.isSelected();
                }
            });
            gc.weighty = 1.0;
            ++gc.gridy;
            this.add((Component)this.myReportFieldsCheckbox, gc);
        }
    }
}

