/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AnnotateMethodFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.AnnotateMethodFix");
    private final String myAnnotation;
    private final String[] myAnnotationsToRemove;

    public AnnotateMethodFix(String fqn, String ... annotationsToRemove) {
        this.myAnnotation = fqn;
        this.myAnnotationsToRemove = annotationsToRemove;
    }

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.annotate.method.quickfix.name", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AnnotateMethodFix.getName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/AnnotateMethodFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/AnnotateMethodFix.applyFix must not be null");
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (method == null) {
            return;
        }
        ArrayList<PsiMethod> toAnnotate = new ArrayList<PsiMethod>();
        toAnnotate.add(method);
        List superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, (String)this.myAnnotation, (boolean)false) || !superMethod.getManager().isInProject((PsiElement)superMethod)) continue;
            int ret = this.annotateBaseMethod(method, superMethod, project);
            if (ret != 0 && ret != 1) {
                return;
            }
            if (ret != 0) continue;
            toAnnotate.add(superMethod);
        }
        if (this.annotateOverriddenMethods()) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)this.myAnnotation, (boolean)false) || !psiMethod.getManager().isInProject((PsiElement)psiMethod)) continue;
                toAnnotate.add(psiMethod);
            }
        }
        CodeInsightUtilBase.preparePsiElementsForWrite(toAnnotate);
        for (PsiMethod psiMethod : toAnnotate) {
            this.annotateMethod(psiMethod);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)method.getContainingFile());
    }

    public int annotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
        String implement = !method.hasModifierProperty("abstract") && superMethod.hasModifierProperty("abstract") ? InspectionsBundle.message((String)"inspection.annotate.quickfix.implements", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.annotate.quickfix.overrides", (Object[])new Object[0]);
        String message = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.messages", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)method), implement, UsageViewUtil.getDescriptiveName((PsiElement)superMethod)});
        String title = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.warning", (Object[])new Object[0]);
        return Messages.showYesNoCancelDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
    }

    protected boolean annotateOverriddenMethods() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/AnnotateMethodFix.getFamilyName must not return null");
        }
        return string;
    }

    private void annotateMethod(PsiMethod method) {
        try {
            new AddAnnotationFix(this.myAnnotation, (PsiModifierListOwner)method, this.myAnnotationsToRemove).invoke(method.getProject(), null, method.getContainingFile());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

