/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.MacroParser;
import com.intellij.codeInsight.template.impl.SelectionNode;

public class Variable
implements Cloneable {
    private final String myName;
    private boolean myAlwaysStopAt;
    private String myExpressionString;
    private Expression myExpression = null;
    private String myDefaultValueString;
    private Expression myDefaultValueExpression;

    public Variable(String name, Expression expression, Expression defaultValueExpression, boolean alwaysStopAt) {
        this.myName = name;
        this.myExpression = expression;
        this.myDefaultValueExpression = defaultValueExpression;
        this.myAlwaysStopAt = alwaysStopAt;
    }

    public Variable(String name, String expression, String defaultValueString, boolean alwaysStopAt) {
        this.myName = name;
        this.myExpressionString = expression;
        this.myDefaultValueString = defaultValueString;
        this.myAlwaysStopAt = alwaysStopAt;
    }

    public String getExpressionString() {
        return this.myExpressionString;
    }

    public void setExpressionString(String expressionString) {
        this.myExpressionString = expressionString;
        this.myExpression = null;
    }

    public Expression getExpression() {
        if (this.myExpression == null) {
            this.myExpression = this.myName.equals("SELECTION") ? new SelectionNode() : MacroParser.parse(this.myExpressionString);
        }
        return this.myExpression;
    }

    public String getDefaultValueString() {
        return this.myDefaultValueString;
    }

    public void setDefaultValueString(String defaultValueString) {
        this.myDefaultValueString = defaultValueString;
        this.myDefaultValueExpression = null;
    }

    public Expression getDefaultValueExpression() {
        if (this.myDefaultValueExpression == null) {
            this.myDefaultValueExpression = MacroParser.parse(this.myDefaultValueString);
        }
        return this.myDefaultValueExpression;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isAlwaysStopAt() {
        if (this.myName.equals("SELECTION")) {
            return false;
        }
        return this.myAlwaysStopAt;
    }

    public void setAlwaysStopAt(boolean alwaysStopAt) {
        this.myAlwaysStopAt = alwaysStopAt;
    }

    public Object clone() {
        return new Variable(this.myName, this.myExpressionString, this.myDefaultValueString, this.myAlwaysStopAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)o;
        if (this.myAlwaysStopAt != variable.myAlwaysStopAt) {
            return false;
        }
        if (this.myDefaultValueString != null ? !this.myDefaultValueString.equals(variable.myDefaultValueString) : variable.myDefaultValueString != null) {
            return false;
        }
        if (this.myExpressionString != null ? !this.myExpressionString.equals(variable.myExpressionString) : variable.myExpressionString != null) {
            return false;
        }
        return !(this.myName != null ? !this.myName.equals(variable.myName) : variable.myName != null);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 29 * result + (this.myAlwaysStopAt ? 1 : 0);
        result = 29 * result + (this.myExpressionString != null ? this.myExpressionString.hashCode() : 0);
        result = 29 * result + (this.myDefaultValueString != null ? this.myDefaultValueString.hashCode() : 0);
        return result;
    }
}

