/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.MacroParser;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class TemplateImplUtil {
    private TemplateImplUtil() {
    }

    public static boolean validateTemplateText(String s) {
        IElementType tokenType;
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(s);
        int end = -1;
        while ((tokenType = lexer.getTokenType()) != null) {
            int start = lexer.getTokenStart();
            if (tokenType == TemplateTokenType.VARIABLE) {
                if (start == end) {
                    return false;
                }
                end = lexer.getTokenEnd();
            } else {
                end = -1;
            }
            lexer.advance();
        }
        return true;
    }

    public static void parseVariables(CharSequence text, ArrayList variables, Set predefinedVars) {
        IElementType tokenType;
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(text);
        while ((tokenType = lexer.getTokenType()) != null) {
            int start = lexer.getTokenStart();
            int end = lexer.getTokenEnd();
            String token = ((Object)text.subSequence(start, end)).toString();
            if (tokenType == TemplateTokenType.VARIABLE) {
                String name = token.substring(1, token.length() - 1);
                boolean isFound = false;
                if (predefinedVars != null && predefinedVars.contains(name) && !name.equals("SELECTION")) {
                    isFound = true;
                } else {
                    for (Object variable1 : variables) {
                        Variable variable = (Variable)variable1;
                        if (!variable.getName().equals(name)) continue;
                        isFound = true;
                        break;
                    }
                }
                if (!isFound) {
                    variables.add(new Variable(name, "", "", true));
                }
            }
            lexer.advance();
        }
    }

    public static Expression parseTemplate(@NonNls String text) {
        return MacroParser.parse(text);
    }
}

