/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class TemplateContext {
    private final Map<String, Boolean> myAdditionalContexts = new LinkedHashMap<String, Boolean>();

    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myAdditionalContexts.putAll(this.myAdditionalContexts);
        return cloneResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(TemplateContextType contextType) {
        Boolean storedValue;
        Map<String, Boolean> map = this.myAdditionalContexts;
        synchronized (map) {
            storedValue = this.myAdditionalContexts.get(contextType.getContextId());
        }
        return storedValue == null ? false : storedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TemplateContextType contextType, boolean value) {
        Map<String, Boolean> map = this.myAdditionalContexts;
        synchronized (map) {
            this.myAdditionalContexts.put(contextType.getContextId(), value);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        List options = element.getChildren("option");
        for (Object e : options) {
            if (!(e instanceof Element)) continue;
            Element option = (Element)e;
            String name = option.getAttributeValue("name");
            String value = option.getAttributeValue("value");
            if (name == null || value == null) continue;
            this.myAdditionalContexts.put(name, Boolean.parseBoolean(value));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String contextName : this.myAdditionalContexts.keySet()) {
            Element optionElement = new Element("option");
            optionElement.setAttribute("name", contextName);
            optionElement.setAttribute("value", this.myAdditionalContexts.get(contextName).toString());
            element.addContent(optionElement);
        }
    }
}

