/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.template.TemplateLookupSelectionHandler;
import com.intellij.codeInsight.template.impl.JavaTemplateLookupSelectionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;

public class JavaTemplateUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.JavaTemplateUtil");

    private JavaTemplateUtil() {
    }

    public static void updateTypeBindings(Object item, PsiFile file, Document document, int segmentStart, int segmentEnd) {
        Project project = file.getProject();
        PsiClass aClass = null;
        if (item instanceof PsiClass) {
            aClass = (PsiClass)item;
        } else if (item instanceof PsiType) {
            aClass = PsiUtil.resolveClassInType((PsiType)((PsiType)item));
        }
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                PsiElement element;
                PsiMethod method;
                if (((PsiTypeParameter)aClass).getOwner() instanceof PsiMethod && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(segmentStart)), PsiMethod.class)) != null) {
                    PsiTypeParameter[] params;
                    PsiTypeParameterList paramList = method.getTypeParameterList();
                    for (PsiTypeParameter param : params = paramList.getTypeParameters()) {
                        if (!param.getName().equals(aClass.getName())) continue;
                        return;
                    }
                    try {
                        paramList.add(aClass.copy());
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            } else {
                JavaTemplateUtil.addImportForClass(document, aClass, segmentStart, segmentEnd);
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            }
        }
    }

    public static void addImportForClass(Document document, final PsiClass aClass, int start, int end) {
        Project project = aClass.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!aClass.isValid() || aClass.getQualifiedName() == null) {
            return;
        }
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper helper = manager.getResolveHelper();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        CharSequence chars = document.getCharsSequence();
        PsiElement element = file.findElementAt(start);
        String refText = ((Object)chars.subSequence(start, end)).toString();
        PsiClass refClass = helper.resolveReferencedClass(refText, element);
        if (aClass.equals(refClass)) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            PsiElement tmp;
            PsiElement parent = element.getParent();
            while (parent != null && (tmp = parent.getParent()) instanceof PsiJavaCodeReferenceElement && tmp.getTextRange().getEndOffset() <= end) {
                parent = tmp;
            }
            if (parent instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)parent).isQualified()) {
                final PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)parent;
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ref.bindToElement((PsiElement)aClass);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }
    }

    public static LookupElement addElementLookupItem(Set<LookupElement> items, PsiElement element) {
        return JavaTemplateUtil.addJavaLookupItem(items, element);
    }

    public static LookupElement addTypeLookupItem(Set<LookupElement> items, PsiType type) {
        return JavaTemplateUtil.addJavaLookupItem(items, type);
    }

    private static LookupElement addJavaLookupItem(Set<LookupElement> items, Object element) {
        LookupElement item = LookupItemUtil.addLookupItem(items, element);
        if (item instanceof LookupItem) {
            ((LookupItem)item).setAttribute(TemplateLookupSelectionHandler.KEY_IN_LOOKUP_ITEM, new JavaTemplateLookupSelectionHandler());
        }
        return item;
    }
}

