/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.intention.impl.ImplementAbstractMethodAction;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;

public class CopyAbstractMethodImplementationHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.CopyAbstractMethodImplementationHandler");
    private final Project myProject;
    private final Editor myEditor;
    private final PsiMethod myMethod;
    private PsiClass mySourceClass;
    private final List<PsiClass> myTargetClasses = new ArrayList<PsiClass>();
    private final List<PsiMethod> mySourceMethods = new ArrayList<PsiMethod>();

    public CopyAbstractMethodImplementationHandler(Project project, Editor editor, PsiMethod method) {
        this.myProject = project;
        this.myEditor = editor;
        this.myMethod = method;
    }

    public void invoke() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                CopyAbstractMethodImplementationHandler.this.searchExistingImplementations();
            }
        }, CodeInsightBundle.message((String)"searching.for.implementations", (Object[])new Object[0]), false, this.myProject);
        if (this.mySourceMethods.isEmpty()) {
            Messages.showErrorDialog((Project)this.myProject, (String)CodeInsightBundle.message((String)"copy.abstract.method.no.existing.implementations.found", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"copy.abstract.method.title", (Object[])new Object[0]));
            return;
        }
        if (this.mySourceMethods.size() == 1) {
            this.copyImplementation(this.mySourceMethods.get(0));
        } else {
            Collections.sort(this.mySourceMethods, new Comparator<PsiMethod>(){

                @Override
                public int compare(PsiMethod o1, PsiMethod o2) {
                    PsiClass c1 = o1.getContainingClass();
                    PsiClass c2 = o2.getContainingClass();
                    return Comparing.compare((Comparable)((Object)c1.getName()), (Comparable)((Object)c2.getName()));
                }
            });
            PsiMethod[] methodArray = this.mySourceMethods.toArray(new PsiMethod[this.mySourceMethods.size()]);
            final JList<PsiMethod> list = new JList<PsiMethod>(methodArray);
            list.setCellRenderer(new MethodCellRenderer(true));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int index = list.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    PsiMethod element = (PsiMethod)list.getSelectedValue();
                    CopyAbstractMethodImplementationHandler.this.copyImplementation(element);
                }
            };
            new PopupChooserBuilder(list).setTitle(CodeInsightBundle.message((String)"copy.abstract.method.popup.title", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(this.myEditor);
        }
    }

    private void searchExistingImplementations() {
        this.mySourceClass = this.myMethod.getContainingClass();
        if (!this.mySourceClass.isValid()) {
            return;
        }
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)this.mySourceClass, (SearchScope)this.mySourceClass.getUseScope(), (boolean)true)) {
            if (inheritor.isInterface()) continue;
            PsiMethod method = ImplementAbstractMethodAction.findExistingImplementation(inheritor, this.myMethod);
            if (method != null && !method.hasModifierProperty("abstract")) {
                this.mySourceMethods.add(method);
                continue;
            }
            if (method != null) continue;
            this.myTargetClasses.add(inheritor);
        }
        Iterator<PsiClass> targetClassIterator = this.myTargetClasses.iterator();
        while (targetClassIterator.hasNext()) {
            PsiClass targetClass = targetClassIterator.next();
            if (!this.containsAnySuperClass(targetClass)) continue;
            targetClassIterator.remove();
        }
    }

    private boolean containsAnySuperClass(PsiClass targetClass) {
        for (PsiClass superClass = targetClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
            if (!this.myTargetClasses.contains(superClass)) continue;
            return true;
        }
        return false;
    }

    private void copyImplementation(final PsiMethod sourceMethod) {
        PsiMethod target;
        PsiFile psiFile;
        FileEditorManager fileEditorManager;
        Editor editor;
        final ArrayList generatedMethods = new ArrayList();
        new WriteCommandAction(this.myProject, this.getTargetFiles()){

            protected void run(Result result) throws Throwable {
                for (PsiClass psiClass : CopyAbstractMethodImplementationHandler.this.myTargetClasses) {
                    Collection<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethod(psiClass, CopyAbstractMethodImplementationHandler.this.myMethod, true);
                    PsiMethod overriddenMethod = methods.iterator().next();
                    PsiCodeBlock body = overriddenMethod.getBody();
                    PsiCodeBlock sourceBody = sourceMethod.getBody();
                    assert (body != null && sourceBody != null);
                    ChangeContextUtil.encodeContextInfo((PsiElement)sourceBody, true);
                    PsiElement newBody = body.replace(sourceBody.copy());
                    ChangeContextUtil.decodeContextInfo(newBody, psiClass, null);
                    PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)CopyAbstractMethodImplementationHandler.this.mySourceClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(psiClass, sourceMethod, substitutor);
                    try {
                        overriddenMethod = anchor != null ? (PsiMethod)anchor.getParent().addBefore((PsiElement)overriddenMethod, anchor) : (PsiMethod)psiClass.addBefore((PsiElement)overriddenMethod, (PsiElement)psiClass.getRBrace());
                        generatedMethods.add(overriddenMethod);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }.execute();
        if (generatedMethods.size() > 0 && (editor = (fileEditorManager = FileEditorManager.getInstance((Project)(psiFile = (target = (PsiMethod)generatedMethods.get(0)).getContainingFile()).getProject())).openTextEditor(new OpenFileDescriptor(psiFile.getProject(), psiFile.getVirtualFile()), false)) != null) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)target, true);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    private PsiFile[] getTargetFiles() {
        HashSet<PsiFile> fileList = new HashSet<PsiFile>();
        for (PsiClass psiClass : this.myTargetClasses) {
            fileList.add(psiClass.getContainingFile());
        }
        return fileList.toArray(new PsiFile[fileList.size()]);
    }
}

