/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSingleMemberStaticImportAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction");
    private static final Key<PsiElement> TEMP_REFERENT_USER_DATA = new Key("TEMP_REFERENT_USER_DATA");

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.single.member.static.import.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/AddSingleMemberStaticImportAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AddSingleMemberStaticImportAction.isAvailable must not be null");
        }
        if (element == null || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiReferenceExpression && ((PsiReferenceExpression)element.getParent()).getQualifierExpression() != null) {
            String qName;
            PsiClass aClass;
            PsiReferenceExpression refExpr = (PsiReferenceExpression)element.getParent();
            if (refExpr.getParameterList() != null && refExpr.getParameterList().getFirstChild() != null) {
                return false;
            }
            PsiElement resolved = refExpr.resolve();
            if (resolved instanceof PsiMember && ((PsiModifierListOwner)resolved).hasModifierProperty("static") && (aClass = ((PsiMember)resolved).getContainingClass()) != null && !PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)element, (boolean)true) && (qName = aClass.getQualifiedName()) != null) {
                qName = qName + "." + refExpr.getReferenceName();
                if (file instanceof PsiJavaFile && ((PsiJavaFile)file).getImportList().findSingleImportStatement(refExpr.getReferenceName()) == null) {
                    this.setText(CodeInsightBundle.message((String)"intention.add.single.member.static.import.text", (Object[])new Object[]{qName}));
                    return true;
                }
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/AddSingleMemberStaticImportAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        final PsiReferenceExpression refExpr = (PsiReferenceExpression)element.getParent();
        final PsiElement resolved = refExpr.resolve();
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement resolved;
                super.visitReferenceExpression(expression);
                if (refExpr.getReferenceName().equals(expression.getReferenceName()) && (resolved = expression.resolve()) != null) {
                    expression.putUserData(TEMP_REFERENT_USER_DATA, (Object)resolved);
                }
            }
        });
        ((PsiReferenceExpressionImpl)refExpr).bindToElementViaStaticImport(((PsiMember)resolved).getContainingClass(), ((PsiNamedElement)resolved).getName(), ((PsiJavaFile)file).getImportList());
        file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.getParameterList() != null && expression.getParameterList().getFirstChild() != null) {
                    return;
                }
                if (refExpr.getReferenceName().equals(expression.getReferenceName())) {
                    PsiElement aClass;
                    if (!expression.isQualified()) {
                        PsiElement referent = (PsiElement)expression.getUserData(TEMP_REFERENT_USER_DATA);
                        if (referent instanceof PsiMember && referent != expression.resolve()) {
                            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
                            try {
                                PsiReferenceExpression copy = (PsiReferenceExpression)factory.createExpressionFromText("A." + expression.getReferenceName(), null);
                                expression = (PsiReferenceExpression)expression.replace((PsiElement)copy);
                                ((PsiReferenceExpression)expression.getQualifierExpression()).bindToElement((PsiElement)((PsiMember)referent).getContainingClass());
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                        expression.putUserData(TEMP_REFERENT_USER_DATA, null);
                    } else if (expression.getQualifierExpression() instanceof PsiReferenceExpression && (aClass = ((PsiReferenceExpression)expression.getQualifierExpression()).resolve()) == ((PsiMember)resolved).getContainingClass()) {
                        try {
                            expression.getQualifierExpression().delete();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    expression.putUserData(TEMP_REFERENT_USER_DATA, null);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }
}

