/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.SideBorder2;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class HintUtil {
    public static final Color INFORMATION_COLOR = new Color(253, 254, 226);
    public static final Color QUESTION_COLOR = new Color(181, 208, 251);
    private static final Color ERROR_COLOR = new Color(255, 220, 220);
    private static final Icon INFORMATION_ICON = null;
    private static final Icon QUESTION_ICON = IconLoader.getIcon((String)"/actions/help.png");
    private static final Icon ERROR_ICON = null;
    public static final Color QUESTION_UNDERSCORE_COLOR = Color.black;

    private HintUtil() {
    }

    public static JLabel createInformationLabel(String text) {
        HintLabel label = new HintLabel();
        ((JLabel)label).setText(text);
        label.setIcon(INFORMATION_ICON);
        label.setBorder(HintUtil.createHintBorder());
        label.setForeground(Color.black);
        label.setFont(HintUtil.getBoldFont());
        label.setBackground(INFORMATION_COLOR);
        label.setOpaque(true);
        return label;
    }

    public static CompoundBorder createHintBorder() {
        return BorderFactory.createCompoundBorder(new SideBorder2(Color.white, Color.white, Color.gray, Color.gray, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public static JComponent createInformationLabel(SimpleColoredText text) {
        return HintUtil.createInformationLabel(text, INFORMATION_ICON);
    }

    public static JLabel createQuestionLabel(String text) {
        HintLabel label = new HintLabel();
        ((JLabel)label).setText(text);
        label.setIcon(QUESTION_ICON);
        label.setBorder(HintUtil.createHintBorder());
        label.setForeground(Color.black);
        label.setFont(HintUtil.getBoldFont());
        label.setBackground(QUESTION_COLOR);
        label.setOpaque(true);
        return label;
    }

    public static JComponent createInformationLabel(SimpleColoredText text, Icon icon) {
        SimpleColoredComponent highlighted = new SimpleColoredComponent();
        highlighted.setIcon(icon);
        highlighted.setBackground(INFORMATION_COLOR);
        highlighted.setForeground(Color.black);
        highlighted.setFont(HintUtil.getBoldFont());
        text.appendToComponent(highlighted);
        Box box = Box.createHorizontalBox();
        box.setBorder(new SideBorder2(Color.white, Color.white, Color.gray, Color.gray, 1));
        box.setForeground(Color.black);
        box.setBackground(INFORMATION_COLOR);
        box.add((Component)highlighted);
        box.setOpaque(true);
        return box;
    }

    public static JLabel createErrorLabel(String text) {
        HintLabel label = new HintLabel();
        ((JLabel)label).setText(text.replaceAll("\n", " "));
        label.setIcon(ERROR_ICON);
        label.setBorder(HintUtil.createHintBorder());
        label.setForeground(Color.black);
        label.setFont(HintUtil.getBoldFont());
        label.setBackground(ERROR_COLOR);
        label.setOpaque(true);
        return label;
    }

    private static Font getBoldFont() {
        return UIUtil.getLabelFont().deriveFont(1);
    }

    public static JLabel createAdComponent(String bottomText) {
        return HintUtil.createAdComponent(bottomText, new EmptyBorder(1, 2, 1, 2));
    }

    public static JLabel createAdComponent(String bottomText, Border border) {
        JLabel label = new JLabel();
        label.setText(bottomText);
        label.setFont(label.getFont().deriveFont((float)(label.getFont().getSize() - 2)));
        if (bottomText != null) {
            label.setBorder(border);
        }
        return label;
    }

    private static class HintLabel
    extends JLabel {
        private HintLabel() {
        }

        @Override
        public void setText(String s) {
            if (s == null) {
                super.setText(null);
            } else {
                int length = s.length();
                String alignedText = length < 100 && !s.contains("\n") ? s : s.replaceAll("(\n)|(\r\n)", " \n ");
                super.setText(" " + alignedText + " ");
            }
        }

        @Override
        public String toString() {
            return "Hint: '" + this.getText() + "'";
        }
    }
}

