/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.PopupActionChooser;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithRangeAdjuster;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageSurrounders;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SurroundWithHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler");
    private static final String CHOOSER_TITLE = CodeInsightBundle.message((String)"surround.with.chooser.title", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler.invoke must not be null");
        }
        SurroundWithHandler.invoke(project, editor, file, null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void invoke(Project project, Editor editor, PsiFile file, Surrounder surrounder) {
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 == null || element2 == null) {
            return;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        for (SurroundWithRangeAdjuster adjuster : (SurroundWithRangeAdjuster[])Extensions.getExtensions((ExtensionPointName)SurroundWithRangeAdjuster.EP_NAME)) {
            if ((textRange = adjuster.adjustSurroundWithRange(file, textRange)) != null) continue;
            return;
        }
        startOffset = textRange.getStartOffset();
        endOffset = textRange.getEndOffset();
        element1 = file.findElementAt(startOffset);
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        Language l = element1.getParent().getLanguage();
        ArrayList surroundDescriptors = new ArrayList();
        surroundDescriptors.addAll(LanguageSurrounders.INSTANCE.allForLanguage(l));
        if (l != baseLanguage) {
            surroundDescriptors.addAll(LanguageSurrounders.INSTANCE.allForLanguage(baseLanguage));
        }
        for (SurroundDescriptor descriptor : surroundDescriptors) {
            PsiElement[] elements = descriptor.getElementsToSurround(file, startOffset, endOffset);
            if (elements.length <= 0) continue;
            if (surrounder == null) {
                PopupActionChooser popupActionChooser = new PopupActionChooser(CHOOSER_TITLE);
                popupActionChooser.invoke(project, editor, file, descriptor.getSurrounders(), elements);
                if (!popupActionChooser.isHasEnabledSurrounders()) continue;
                return;
            }
            SurroundWithHandler.doSurround(project, editor, surrounder, elements);
            return;
        }
        if (surrounder == null) {
            PopupActionChooser popupActionChooser = new PopupActionChooser(CHOOSER_TITLE);
            popupActionChooser.invoke(project, editor, file, new Surrounder[0], new PsiElement[0]);
        }
    }

    static void doSurround(Project project, Editor editor, Surrounder surrounder, PsiElement[] elements) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        try {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            int col = editor.getCaretModel().getLogicalPosition().column;
            int line = editor.getCaretModel().getLogicalPosition().line;
            LogicalPosition pos = new LogicalPosition(0, 0);
            editor.getCaretModel().moveToLogicalPosition(pos);
            TextRange range = surrounder.surroundElements(project, editor, elements);
            if (TemplateManager.getInstance(project).getActiveTemplate(editor) == null) {
                LogicalPosition pos1 = new LogicalPosition(line, col);
                editor.getCaretModel().moveToLogicalPosition(pos1);
            }
            if (range != null) {
                int offset = range.getStartOffset();
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

