/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;

class JavaWithCastSurrounder
extends JavaExpressionSurrounder {
    @NonNls
    private static final String TYPE_TEMPLATE_VARIABLE = "type";

    JavaWithCastSurrounder() {
    }

    public boolean isApplicable(PsiExpression expr) {
        return true;
    }

    public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr) throws IncorrectOperationException {
        PsiType[] types = GuessManager.getInstance(project).guessTypeToCast(expr);
        Template template = JavaWithCastSurrounder.generateTemplate(project, expr.getText(), types);
        TextRange range = expr.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TemplateManager.getInstance(project).startTemplate(editor, template);
        return null;
    }

    private static Template generateTemplate(Project project, String exprText, PsiType[] suggestedTypes) {
        TemplateManager templateManager = TemplateManager.getInstance(project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        LinkedHashSet<LookupItem> itemSet = new LinkedHashSet<LookupItem>();
        for (PsiType type : suggestedTypes) {
            itemSet.add(PsiTypeLookupItem.createLookupItem(type, null));
        }
        final LookupElement[] lookupItems = itemSet.toArray(new LookupElement[itemSet.size()]);
        final PsiTypeResult result = suggestedTypes.length > 0 ? new PsiTypeResult(suggestedTypes[0], project) : null;
        Expression expr = new Expression(){

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return lookupItems.length > 1 ? lookupItems : null;
            }

            public Result calculateResult(ExpressionContext context) {
                return result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }
        };
        template.addTextSegment("((");
        template.addVariable(TYPE_TEMPLATE_VARIABLE, expr, expr, true);
        template.addTextSegment(")" + exprText + ")");
        template.addEndVariable();
        return template;
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.cast.template", (Object[])new Object[0]);
    }
}

