/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class UpdateFoldRegionsOperation
implements Runnable {
    private final Project myProject;
    private final Editor myEditor;
    private final boolean myApplyDefaultState;
    private final Map<PsiElement, FoldingDescriptor> myElementsToFoldMap;
    private final boolean myForInjected;

    UpdateFoldRegionsOperation(Project project, Editor editor, Map<PsiElement, FoldingDescriptor> elementsToFoldMap, boolean applyDefaultState, boolean forInjected) {
        this.myProject = project;
        this.myEditor = editor;
        this.myApplyDefaultState = applyDefaultState;
        this.myElementsToFoldMap = elementsToFoldMap;
        this.myForInjected = forInjected;
    }

    @Override
    public void run() {
        EditorFoldingInfo info = EditorFoldingInfo.get(this.myEditor);
        FoldingModelEx foldingModel = (FoldingModelEx)this.myEditor.getFoldingModel();
        HashMap rangeToExpandStatusMap = new HashMap();
        this.removeInvalidRegions(info, foldingModel, (HashMap<TextRange, Boolean>)rangeToExpandStatusMap);
        THashMap shouldExpand = CollectionFactory.newTroveMap();
        THashMap groupExpand = CollectionFactory.newTroveMap();
        List<FoldRegion> newRegions = this.addNewRegions(info, foldingModel, (Map<TextRange, Boolean>)rangeToExpandStatusMap, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
        UpdateFoldRegionsOperation.applyExpandStatus(newRegions, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
    }

    private static void applyExpandStatus(List<FoldRegion> newRegions, Map<FoldRegion, Boolean> shouldExpand, Map<FoldingGroup, Boolean> groupExpand) {
        for (FoldRegion region : newRegions) {
            FoldingGroup group = region.getGroup();
            Boolean expanded = group == null ? shouldExpand.get(region) : groupExpand.get(group);
            if (expanded == null) continue;
            region.setExpanded(expanded.booleanValue());
        }
    }

    private List<FoldRegion> addNewRegions(EditorFoldingInfo info, FoldingModelEx foldingModel, Map<TextRange, Boolean> rangeToExpandStatusMap, Map<FoldRegion, Boolean> shouldExpand, Map<FoldingGroup, Boolean> groupExpand) {
        ArrayList newRegions = CollectionFactory.arrayList();
        for (Map.Entry<PsiElement, FoldingDescriptor> entry : this.myElementsToFoldMap.entrySet()) {
            ProgressManager.checkCanceled();
            PsiElement element = entry.getKey();
            FoldingDescriptor descriptor = entry.getValue();
            FoldingGroup group = descriptor.getGroup();
            TextRange range = descriptor.getRange();
            String placeholder = descriptor.getPlaceholderText();
            FoldRegion region = foldingModel.createFoldRegion(range.getStartOffset(), range.getEndOffset(), placeholder == null ? "..." : placeholder, group);
            if (!foldingModel.addFoldRegion(region)) continue;
            info.addRegion(region, descriptor);
            newRegions.add(region);
            boolean expandStatus = this.shouldExpandNewRegion(element, range, rangeToExpandStatusMap);
            if (group == null) {
                shouldExpand.put(region, expandStatus);
                continue;
            }
            Boolean alreadyExpanded = groupExpand.get(group);
            groupExpand.put(group, alreadyExpanded == null ? expandStatus : alreadyExpanded != false || expandStatus);
        }
        return newRegions;
    }

    private boolean shouldExpandNewRegion(PsiElement element, TextRange range, Map<TextRange, Boolean> rangeToExpandStatusMap) {
        boolean caretInside = FoldingUtil.caretInsideRange(this.myEditor, range);
        if (this.myApplyDefaultState) {
            return caretInside || !FoldingPolicy.isCollapseByDefault(element);
        }
        Boolean oldStatus = rangeToExpandStatusMap.get(range);
        return oldStatus == null || caretInside || oldStatus != false;
    }

    private void removeInvalidRegions(EditorFoldingInfo info, FoldingModelEx foldingModel, HashMap<TextRange, Boolean> rangeToExpandStatusMap) {
        ArrayList toRemove = CollectionFactory.arrayList();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        for (FoldRegion region : foldingModel.getAllFoldRegions()) {
            PsiFile containingFile;
            boolean isInjected;
            PsiElement element = info.getPsiElement(region);
            if (element != null && (isInjected = injectedManager.isInjectedFragment(containingFile = element.getContainingFile())) != this.myForInjected) continue;
            if (element != null && this.myElementsToFoldMap.containsKey(element)) {
                FoldingDescriptor descriptor = this.myElementsToFoldMap.get(element);
                TextRange range = descriptor.getRange();
                if (!region.isValid() || region.getGroup() != null || descriptor.getGroup() != null || region.getStartOffset() != range.getStartOffset() || region.getEndOffset() != range.getEndOffset() || !region.getPlaceholderText().equals(descriptor.getPlaceholderText()) || range.getLength() < 2) {
                    rangeToExpandStatusMap.put((Object)range, (Object)region.isExpanded());
                    toRemove.add(region);
                    continue;
                }
                this.myElementsToFoldMap.remove(element);
                continue;
            }
            if (region.isValid() && info.isLightRegion(region)) {
                boolean isExpanded = region.isExpanded();
                rangeToExpandStatusMap.put((Object)new TextRange(region.getStartOffset(), region.getEndOffset()), (Object)(isExpanded ? Boolean.TRUE : Boolean.FALSE));
                continue;
            }
            toRemove.add(region);
        }
        for (FoldRegion region : toRemove) {
            foldingModel.removeFoldRegion(region);
            info.removeRegion(region);
        }
    }
}

