/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.JavaFoldingBuilder");
    private static final String SMILEY = "<~>";

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement element, @NotNull Document document, boolean quick) {
        PsiClass[] classes;
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        FoldingDescriptor[] foldingDescriptorArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.buildFoldRegions must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.buildFoldRegions must not be null");
        }
        if (!(element instanceof PsiJavaFile)) {
            foldingDescriptorArray = FoldingDescriptor.EMPTY;
            if (FoldingDescriptor.EMPTY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.buildFoldRegions must not return null");
            return foldingDescriptorArray;
        }
        PsiJavaFile file = (PsiJavaFile)element;
        ArrayList<FoldingDescriptor> result = new ArrayList<FoldingDescriptor>();
        PsiImportList importList = file.getImportList();
        if (importList != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = JavaFoldingBuilder.getRangeToFold((PsiElement)importList)) != null && rangeToFold.getLength() > 1) {
            result.add(new FoldingDescriptor((PsiElement)importList, rangeToFold));
        }
        for (PsiClass aClass : classes = file.getClasses()) {
            ProgressManager.checkCanceled();
            this.addElementsToFold(result, aClass, document, true, quick);
        }
        TextRange range = JavaFoldingBuilder.getFileHeader(file);
        if (range != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            result.add(new FoldingDescriptor((PsiElement)file, range));
        }
        if ((foldingDescriptorArray = result.toArray(new FoldingDescriptor[result.size()])) != null) return foldingDescriptorArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.buildFoldRegions must not return null");
    }

    private void addElementsToFold(List<FoldingDescriptor> list, PsiClass aClass, Document document, boolean foldJavaDocs, boolean quick) {
        PsiElement[] children;
        PsiDocComment docComment;
        if (!(aClass.getParent() instanceof PsiJavaFile) || ((PsiJavaFile)aClass.getParent()).getClasses().length > 1) {
            JavaFoldingBuilder.addToFold(list, (PsiElement)aClass, document, true);
        }
        if (foldJavaDocs && (docComment = aClass.getDocComment()) != null) {
            JavaFoldingBuilder.addToFold(list, (PsiElement)docComment, document, true);
        }
        JavaFoldingBuilder.addAnnotationsToFold(aClass.getModifierList(), list, document);
        for (PsiElement child : children = aClass.getChildren()) {
            ProgressManager.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiCodeBlock body;
                PsiMethod method = (PsiMethod)child;
                JavaFoldingBuilder.addToFold(list, (PsiElement)method, document, true);
                JavaFoldingBuilder.addAnnotationsToFold(method.getModifierList(), list, document);
                if (foldJavaDocs && (docComment = method.getDocComment()) != null) {
                    JavaFoldingBuilder.addToFold(list, (PsiElement)docComment, document, true);
                }
                if ((body = method.getBody()) == null) continue;
                this.addCodeBlockFolds((PsiElement)body, list, document, quick);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                if (foldJavaDocs && (docComment = field.getDocComment()) != null) {
                    JavaFoldingBuilder.addToFold(list, (PsiElement)docComment, document, true);
                }
                JavaFoldingBuilder.addAnnotationsToFold(field.getModifierList(), list, document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds((PsiElement)initializer, list, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds((PsiElement)field, list, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)child;
                JavaFoldingBuilder.addToFold(list, (PsiElement)initializer, document, true);
                this.addCodeBlockFolds((PsiElement)initializer, list, document, quick);
                continue;
            }
            if (!(child instanceof PsiClass)) continue;
            this.addElementsToFold(list, (PsiClass)child, document, true, quick);
        }
    }

    @NotNull
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.getPlaceholderText must not be null");
        }
        String string = JavaFoldingBuilder.getPlaceholderText(SourceTreeToPsiMap.treeElementToPsi(node));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.getPlaceholderText must not return null");
        }
        return string;
    }

    private static String getPlaceholderText(PsiElement element) {
        if (element instanceof PsiImportList) {
            return "...";
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiClass) {
            return "{...}";
        }
        if (element instanceof PsiDocComment) {
            return "/**...*/";
        }
        if (element instanceof PsiFile) {
            return "/.../";
        }
        if (element instanceof PsiAnnotation) {
            return "@{...}";
        }
        if (element instanceof PsiReferenceParameterList) {
            return SMILEY;
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.isCollapsedByDefault must not be null");
        }
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(node);
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (element instanceof PsiNewExpression || element instanceof PsiJavaToken) {
            return settings.isCollapseLambdas();
        }
        if (element instanceof PsiReferenceParameterList) {
            return settings.isCollapseConstructorGenericParameters();
        }
        if (element instanceof PsiImportList) {
            return settings.isCollapseImports();
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiCodeBlock) {
            if (!settings.isCollapseAccessors() && !settings.isCollapseMethods()) {
                return false;
            }
            if (element instanceof PsiMethod && JavaFoldingBuilder.isSimplePropertyAccessor((PsiMethod)element)) {
                return settings.isCollapseAccessors();
            }
            return settings.isCollapseMethods();
        }
        if (element instanceof PsiAnonymousClass) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiClass) {
            return !(element.getParent() instanceof PsiFile) && settings.isCollapseInnerClasses();
        }
        if (element instanceof PsiDocComment) {
            return settings.isCollapseJavadocs();
        }
        if (element instanceof PsiJavaFile) {
            return settings.isCollapseFileHeader();
        }
        if (element instanceof PsiAnnotation) {
            return settings.isCollapseAnnotations();
        }
        LOG.error("Unknown element:" + element);
        return false;
    }

    private static boolean isSimplePropertyAccessor(PsiMethod method) {
        PsiExpression expr;
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
            PsiExpression returnValue;
            if (statement instanceof PsiReturnStatement && (returnValue = ((PsiReturnStatement)statement).getReturnValue()) instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)returnValue).resolve() instanceof PsiField;
            }
        } else if (PropertyUtil.isSimplePropertySetter((PsiMethod)method) && statement instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            if (lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)lhs).resolve() instanceof PsiField && ((PsiReferenceExpression)rhs).resolve() instanceof PsiParameter;
            }
        }
        return false;
    }

    @Nullable
    public static TextRange getRangeToFold(PsiElement element) {
        if (element instanceof PsiMethod) {
            if (element instanceof JspHolderMethod) {
                return null;
            }
            PsiCodeBlock body = ((PsiMethod)element).getBody();
            if (body == null) {
                return null;
            }
            return body.getTextRange();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody().getTextRange();
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiJavaToken lBrace = aClass.getLBrace();
            if (lBrace == null) {
                return null;
            }
            PsiJavaToken rBrace = aClass.getRBrace();
            if (rBrace == null) {
                return null;
            }
            return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
        }
        if (element instanceof PsiJavaFile) {
            return JavaFoldingBuilder.getFileHeader((PsiJavaFile)element);
        }
        if (element instanceof PsiImportList) {
            PsiImportList list = (PsiImportList)element;
            PsiImportStatementBase[] statements = list.getAllImportStatements();
            if (statements.length == 0) {
                return null;
            }
            PsiElement importKeyword = statements[0].getFirstChild();
            if (importKeyword == null) {
                return null;
            }
            int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
            int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            return new TextRange(startOffset, endOffset);
        }
        if (element instanceof PsiDocComment) {
            return element.getTextRange();
        }
        if (element instanceof PsiAnnotation) {
            int startOffset = element.getTextRange().getStartOffset();
            PsiElement last = element;
            while (element instanceof PsiAnnotation) {
                last = element;
                element = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            }
            return new TextRange(startOffset, last.getTextRange().getEndOffset());
        }
        return null;
    }

    @Nullable
    private static TextRange getFileHeader(PsiJavaFile file) {
        PsiElement first = file.getFirstChild();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element = first;
        while (element instanceof PsiComment && (element = element.getNextSibling()) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return null;
        }
        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element == null || element.equals(first)) {
            return null;
        }
        return new TextRange(first.getTextOffset(), element.getTextOffset());
    }

    private static void addAnnotationsToFold(PsiModifierList modifierList, List<FoldingDescriptor> foldElements, Document document) {
        if (modifierList == null) {
            return;
        }
        PsiElement[] children = modifierList.getChildren();
        for (int i = 0; i < children.length; ++i) {
            PsiElement nextChild;
            int j;
            PsiElement child = children[i];
            if (!(child instanceof PsiAnnotation)) continue;
            JavaFoldingBuilder.addToFold(foldElements, child, document, false);
            for (j = i + 1; j < children.length && !((nextChild = children[j]) instanceof PsiModifier); ++j) {
            }
            i = j;
        }
    }

    private void addCodeBlockFolds(PsiElement scope, final List<FoldingDescriptor> foldElements, final Document document, final boolean quick) {
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (!JavaFoldingBuilder.this.addClosureFolding(aClass, document, foldElements, quick)) {
                    JavaFoldingBuilder.addToFold(foldElements, (PsiElement)aClass, document, true);
                    JavaFoldingBuilder.this.addElementsToFold(foldElements, aClass, document, false, quick);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                JavaFoldingBuilder.addMethodGenericParametersFolding(expression, foldElements, document, quick);
                super.visitMethodCallExpression(expression);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                JavaFoldingBuilder.addGenericParametersFolding(expression, foldElements, document, quick);
                super.visitNewExpression(expression);
            }
        });
    }

    private static void addMethodGenericParametersFolding(PsiMethodCallExpression expression, List<FoldingDescriptor> foldElements, Document document, boolean quick) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiReferenceParameterList list = methodExpression.getParameterList();
        if (list == null || list.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element = expression;
        while (true) {
            if (!quick && !JavaFoldingBuilder.resolvesCorrectly(element.getMethodExpression())) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) break;
            element = (PsiMethodCallExpression)parent.getParent();
        }
        JavaFoldingBuilder.addTypeParametersFolding(foldElements, document, list, 3, quick);
    }

    private static boolean resolvesCorrectly(PsiReferenceExpression expression) {
        for (JavaResolveResult result : expression.multiResolve(true)) {
            if (result.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(PsiNewExpression expression, List<FoldingDescriptor> foldElements, Document document, boolean quick) {
        PsiReferenceParameterList list;
        PsiAnonymousClass anonymousClass;
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters = ((PsiClassType)declType).getParameters();
        if (parameters.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression.getClassReference();
        if (classReference == null && (anonymousClass = expression.getAnonymousClass()) != null) {
            classReference = anonymousClass.getBaseClassReference();
            if (quick || JavaFoldingBuilder.seemsLikeLambda(anonymousClass.getSuperClass())) {
                return;
            }
        }
        if (classReference != null && (list = classReference.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !list.getText().equals(declList.getText()) : !Arrays.equals(list.getTypeArguments(), parameters)) {
                return;
            }
            JavaFoldingBuilder.addTypeParametersFolding(foldElements, document, list, 5, quick);
        }
    }

    private static void addTypeParametersFolding(List<FoldingDescriptor> foldElements, Document document, PsiReferenceParameterList list, int ifLongerThan, boolean quick) {
        String text;
        if (!quick) {
            for (PsiType type : list.getTypeArguments()) {
                if (!type.isValid()) {
                    return;
                }
                if (!(type instanceof PsiClassType) && !(type instanceof PsiArrayType) || PsiUtil.resolveClassInType((PsiType)type) != null) continue;
                return;
            }
        }
        if ((text = list.getText()).startsWith("<") && text.endsWith(">") && text.length() > ifLongerThan) {
            TextRange range = list.getTextRange();
            JavaFoldingBuilder.addFoldRegion(foldElements, (PsiElement)list, document, true, new TextRange(range.getStartOffset(), range.getEndOffset()));
        }
    }

    private static boolean hasOnlyOneMethod(@NotNull PsiAnonymousClass anonymousClass) {
        if (anonymousClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/JavaFoldingBuilder.hasOnlyOneMethod must not be null");
        }
        if (anonymousClass.getFields().length != 0) {
            return false;
        }
        if (anonymousClass.getInitializers().length != 0) {
            return false;
        }
        if (anonymousClass.getInnerClasses().length != 0) {
            return false;
        }
        return anonymousClass.getMethods().length == 1;
    }

    private boolean addClosureFolding(PsiClass aClass, Document document, List<FoldingDescriptor> foldElements, final boolean quick) {
        PsiNewExpression expression;
        PsiExpressionList argumentList;
        PsiAnonymousClass anonymousClass;
        PsiElement element;
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        boolean isClosure = false;
        if (aClass instanceof PsiAnonymousClass && (element = (anonymousClass = (PsiAnonymousClass)aClass).getParent()) instanceof PsiNewExpression && (argumentList = (expression = (PsiNewExpression)element).getArgumentList()) != null && argumentList.getExpressions().length == 0) {
            PsiMethod method;
            PsiCodeBlock body;
            PsiMethod[] methods = anonymousClass.getMethods();
            if (JavaFoldingBuilder.hasOnlyOneMethod(anonymousClass) && (quick || JavaFoldingBuilder.seemsLikeLambda(anonymousClass.getBaseClassType().resolve())) && (body = (method = methods[0]).getBody()) != null) {
                String baseClassName;
                int lastLineEnd;
                int methodEndLine;
                int methodEndLineStart;
                PsiJavaToken rbrace;
                isClosure = true;
                int rangeStart = body.getTextRange().getStartOffset();
                int rangeEnd = body.getTextRange().getEndOffset();
                PsiJavaToken lbrace = body.getLBrace();
                if (lbrace != null) {
                    rangeStart = lbrace.getTextRange().getEndOffset();
                }
                if ((rbrace = body.getRBrace()) != null) {
                    rangeEnd = rbrace.getTextRange().getStartOffset();
                }
                CharSequence seq = document.getCharsSequence();
                PsiJavaToken classRBrace = anonymousClass.getRBrace();
                if (classRBrace != null && rbrace != null && "}".equals(((Object)seq.subSequence(methodEndLineStart = document.getLineStartOffset(methodEndLine = document.getLineNumber(rangeEnd)), document.getLineEndOffset(methodEndLine))).toString().trim())) {
                    int classEndStart = classRBrace.getTextRange().getStartOffset();
                    int classEndCol = classEndStart - document.getLineStartOffset(document.getLineNumber(classEndStart));
                    rangeEnd = classEndCol + methodEndLineStart;
                }
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)aClass.getProject());
                int firstLineStart = CharArrayUtil.shiftForward((CharSequence)seq, (int)rangeStart, (String)" \t");
                if (firstLineStart < seq.length() - 1 && seq.charAt(firstLineStart) == '\n') {
                    ++firstLineStart;
                }
                if ((lastLineEnd = CharArrayUtil.shiftBackward((CharSequence)seq, (int)(rangeEnd - 1), (String)" \t")) > 0 && seq.charAt(lastLineEnd) == '\n') {
                    --lastLineEnd;
                }
                if (lastLineEnd < firstLineStart) {
                    return false;
                }
                String string = baseClassName = quick ? anonymousClass.getBaseClassReference().getReferenceName() : anonymousClass.getBaseClassType().resolve().getName();
                if (lastLineEnd >= seq.length() || firstLineStart >= seq.length() || firstLineStart < 0) {
                    LOG.error("llE=" + lastLineEnd + "; fLS=" + firstLineStart + "; len=" + seq.length() + "rE=" + rangeEnd + "; class=" + baseClassName);
                }
                String params = StringUtil.join((Object[])method.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){

                    public String fun(PsiParameter psiParameter) {
                        String typeName = quick ? psiParameter.getTypeElement().getText() : psiParameter.getType().getPresentableText();
                        int genStart = typeName.indexOf(60);
                        int genEnd = typeName.lastIndexOf(62);
                        if (genStart > 0 && genEnd > 0) {
                            typeName = typeName.substring(0, genStart) + typeName.substring(genEnd + 1);
                        }
                        return typeName + " " + psiParameter.getName();
                    }
                }, (String)", ");
                final String lambdas = baseClassName + "(" + params + ") {";
                int closureStart = expression.getTextRange().getStartOffset();
                int closureEnd = expression.getTextRange().getEndOffset();
                boolean oneLine = false;
                String contents = ((Object)seq.subSequence(firstLineStart, lastLineEnd)).toString();
                if (contents.indexOf(10) < 0) {
                    int beforeLength = closureStart - document.getLineStartOffset(document.getLineNumber(closureStart));
                    int afterLength = document.getLineEndOffset(document.getLineNumber(closureEnd)) - closureEnd;
                    int resultLineLength = beforeLength + lambdas.length() + contents.length() + 5 + afterLength;
                    if (resultLineLength <= settings.RIGHT_MARGIN) {
                        rangeStart = CharArrayUtil.shiftForward((CharSequence)seq, (int)rangeStart, (String)" \n\t");
                        rangeEnd = CharArrayUtil.shiftBackward((CharSequence)seq, (int)(rangeEnd - 1), (String)" \n\t") + 1;
                        oneLine = true;
                    }
                }
                if (rangeStart >= rangeEnd) {
                    return false;
                }
                FoldingGroup group = FoldingGroup.newGroup((String)"lambda");
                final String prettySpace = oneLine ? " " : "";
                foldElements.add(new FoldingDescriptor(expression.getNode(), new TextRange(closureStart, rangeStart), group){

                    public String getPlaceholderText() {
                        return lambdas + prettySpace;
                    }
                });
                if (rbrace != null && rangeEnd + 1 < closureEnd) {
                    foldElements.add(new FoldingDescriptor(rbrace.getNode(), new TextRange(rangeEnd, closureEnd), group){

                        public String getPlaceholderText() {
                            return prettySpace + "}";
                        }
                    });
                }
                this.addCodeBlockFolds((PsiElement)body, foldElements, document, quick);
            }
        }
        return isClosure;
    }

    private static boolean seemsLikeLambda(@Nullable PsiClass baseClass) {
        if (baseClass == null) {
            return false;
        }
        if (!baseClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (!PsiUtil.hasDefaultConstructor((PsiClass)baseClass, (boolean)true)) {
            return false;
        }
        for (PsiMethod method : baseClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return true;
        }
        return false;
    }

    private static boolean addToFold(List<FoldingDescriptor> list, PsiElement elementToFold, Document document, boolean allowOneLiners) {
        LOG.assertTrue(elementToFold.isValid());
        TextRange range = JavaFoldingBuilder.getRangeToFold(elementToFold);
        if (range == null) {
            return false;
        }
        return JavaFoldingBuilder.addFoldRegion(list, elementToFold, document, allowOneLiners, range);
    }

    private static boolean addFoldRegion(List<FoldingDescriptor> list, PsiElement elementToFold, Document document, boolean allowOneLiners, TextRange range) {
        TextRange fileRange = elementToFold.getContainingFile().getTextRange();
        if (range.equals((Object)fileRange)) {
            return false;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (range.getStartOffset() < 0 || range.getEndOffset() > fileRange.getEndOffset()) {
            return false;
        }
        if (!allowOneLiners) {
            int endLine;
            int startLine = document.getLineNumber(range.getStartOffset());
            if (startLine < (endLine = document.getLineNumber(range.getEndOffset() - 1)) && range.getLength() > 1) {
                list.add(new FoldingDescriptor(elementToFold, range));
                return true;
            }
            return false;
        }
        if (range.getLength() > JavaFoldingBuilder.getPlaceholderText(elementToFold).length()) {
            list.add(new FoldingDescriptor(elementToFold, range));
            return true;
        }
        return false;
    }
}

