/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CollapseRegionHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CollapseRegionHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CollapseRegionHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/folding/impl/CollapseRegionHandler.invoke must not be null");
        }
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        final int line = editor.getCaretModel().getLogicalPosition().line;
        Runnable processor = new Runnable(){

            @Override
            public void run() {
                FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine(editor, line);
                if (region != null && region.isExpanded()) {
                    region.setExpanded(false);
                } else {
                    FoldRegion[] regions;
                    int offset = editor.getCaretModel().getOffset();
                    for (FoldRegion region1 : regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset)) {
                        if (!region1.isExpanded()) continue;
                        region1.setExpanded(false);
                        break;
                    }
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

