/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;

public class StringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Override
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        boolean isLiteral = true;
        for (int i = 0; i < startOffsets.length && isLiteral; ++i) {
            int startOffset = startOffsets[i];
            PsiElement elementAtCaret = file.findElementAt(startOffset);
            if (elementAtCaret instanceof PsiJavaToken && ((PsiJavaToken)elementAtCaret).getTokenType() == JavaTokenType.STRING_LITERAL && startOffset > elementAtCaret.getTextRange().getStartOffset() && endOffsets[i] < elementAtCaret.getTextRange().getEndOffset()) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @Override
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement elementAtCaret = file.findElementAt(caretOffset);
        if (elementAtCaret instanceof PsiJavaToken && caretOffset > elementAtCaret.getTextOffset()) {
            IElementType tokenType = ((PsiJavaToken)elementAtCaret).getTokenType();
            if (tokenType == JavaTokenType.STRING_LITERAL) {
                if (rawText != null && rawText.rawText != null) {
                    return rawText.rawText;
                }
                StringBuilder buffer = new StringBuilder(text.length());
                CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
                String breaker = codeStyleSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\\n\"\n+ \"" : "\\n\" +\n\"";
                String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    buffer.append(StringUtil.escapeStringCharacters((String)line));
                    if (i == lines.length - 1) continue;
                    buffer.append(breaker);
                }
                text = buffer.toString();
            } else if (tokenType == JavaTokenType.CHARACTER_LITERAL && rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
        }
        return text;
    }
}

