/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedParameterFix
extends IntentionAndQuickFixAction {
    private final PsiParameter myParameter;

    public RemoveUnusedParameterFix(PsiParameter parameter) {
        this.myParameter = parameter;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("remove.unused.parameter.text", this.myParameter.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.unused.parameter.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix.isAvailable must not be null");
        }
        return this.myParameter.isValid() && this.myParameter.getDeclarationScope() instanceof PsiMethod && this.myParameter.getManager().isInProject((PsiElement)this.myParameter);
    }

    public void applyFix(Project project, PsiFile file, @Nullable Editor editor) {
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myParameter.getContainingFile())) {
            return;
        }
        RemoveUnusedParameterFix.removeReferences(this.myParameter);
    }

    private static void removeReferences(PsiParameter parameter) {
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        ChangeSignatureProcessor processor = new ChangeSignatureProcessor(parameter.getProject(), method, false, null, method.getName(), method.getReturnType(), RemoveUnusedParameterFix.getNewParametersInfo(method, parameter));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor.run();
        } else {
            processor.run();
        }
    }

    public static ParameterInfoImpl[] getNewParametersInfo(PsiMethod method, PsiParameter parameterToRemove) {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (Comparing.equal((Object)parameter, (Object)parameterToRemove)) continue;
            result.add(new ParameterInfoImpl(i, parameter.getName(), parameter.getType()));
        }
        return result.toArray(new ParameterInfoImpl[result.size()]);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

