/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodFromUsageFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix");
    private final SmartPsiElementPointer myMethodCall;

    public CreateMethodFromUsageFix(PsiMethodCallExpression methodCall) {
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCall.getProject()).createSmartPsiElementPointer((PsiElement)methodCall);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null) {
            return false;
        }
        PsiReferenceExpression ref = call.getMethodExpression();
        String name = ref.getReferenceName();
        if (name == null || !JavaPsiFacade.getInstance((Project)ref.getProject()).getNameHelper().isIdentifier(name)) {
            return false;
        }
        if (CreateMethodFromUsageFix.hasErrorsInArgumentList(call)) {
            return false;
        }
        this.setText(this.getDisplayString(name));
        return true;
    }

    protected String getDisplayString(String name) {
        return QuickFixBundle.message("create.method.from.usage.text", name);
    }

    private static boolean isMethodSignatureExists(PsiMethodCallExpression call, PsiClass target) {
        PsiMethod[] methods;
        String name = call.getMethodExpression().getReferenceName();
        PsiExpressionList list = call.getArgumentList();
        for (PsiMethod method : methods = target.findMethodsByName(name, false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpressionList)list)) continue;
            return true;
        }
        return false;
    }

    static boolean hasErrorsInArgumentList(PsiMethodCallExpression call) {
        Project project = call.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(call.getContainingFile());
        if (document == null) {
            return true;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        List<HighlightInfo> errorsInArgList = DaemonCodeAnalyzerImpl.getHighlights(document, HighlightSeverity.ERROR, project, argumentList.getTextRange().getStartOffset() + 1, argumentList.getTextRange().getEndOffset() - 1);
        return !errorsInArgList.isEmpty();
    }

    @Override
    protected PsiElement getElement() {
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null || !call.getManager().isInProject((PsiElement)call)) {
            return null;
        }
        return call;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> list;
        List<PsiClass> targets = super.getTargetClasses(element);
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix.getTargetClasses must not return null");
            return list;
        }
        for (PsiClass target : targets) {
            if (CreateMethodFromUsageFix.isMethodSignatureExists(call, target)) continue;
            result.add(target);
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix.getTargetClasses must not return null");
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        if (targetClass == null) {
            return;
        }
        PsiMethodCallExpression expression = this.getMethodCall();
        if (expression == null) {
            return;
        }
        Project project = expression.getProject();
        PsiReferenceExpression ref = expression.getMethodExpression();
        if (this.isValidElement((PsiElement)expression)) {
            return;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
        PsiMember enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class});
        String methodName = ref.getReferenceName();
        LOG.assertTrue(methodName != null);
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod method = factory.createMethod(methodName, PsiType.VOID);
            if (targetClass.equals(parentClass)) {
                method = (PsiMethod)targetClass.addAfter((PsiElement)method, (PsiElement)enclosingContext);
            } else {
                PsiMember anchor;
                for (anchor = enclosingContext; anchor != null && anchor.getParent() != null && !anchor.getParent().equals(targetClass); anchor = anchor.getParent()) {
                }
                if (anchor != null && anchor.getParent() == null) {
                    anchor = null;
                }
                method = anchor != null ? (PsiMethod)targetClass.addAfter((PsiElement)method, (PsiElement)anchor) : (PsiMethod)targetClass.add((PsiElement)method);
            }
            if (enclosingContext instanceof PsiMethod && methodName.equals(enclosingContext.getName()) && PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)parentClass, (boolean)true)) {
                FieldConflictsResolver.qualifyReference(ref, (PsiMember)method, null);
            }
            PsiCodeBlock body = method.getBody();
            assert (body != null);
            if (this.shouldBeAbstract(targetClass)) {
                body.delete();
                if (!targetClass.isInterface()) {
                    method.getModifierList().setModifierProperty("abstract", true);
                }
            }
            this.setupVisibility(parentClass, targetClass, method.getModifierList());
            if (CreateMethodFromUsageFix.shouldCreateStaticMember(expression.getMethodExpression(), targetClass) && !this.shouldBeAbstract(targetClass)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
            Object[] arguments = expression.getArgumentList().getExpressions();
            CreateMethodFromUsageFix.doCreate(targetClass, method, this.shouldBeAbstract(targetClass), ContainerUtil.map2List((Object[])arguments, (Function)new Function<PsiExpression, Pair<PsiExpression, PsiType>>(){

                public Pair<PsiExpression, PsiType> fun(PsiExpression psiExpression) {
                    return Pair.create((Object)psiExpression, null);
                }
            }), CreateMethodFromUsageFix.getTargetSubstitutor((PsiElement)expression), CreateFromUsageUtils.guessExpectedTypes((PsiExpression)expression, true), context);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void doCreate(PsiClass targetClass, PsiMethod method, List<Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        CreateMethodFromUsageFix.doCreate(targetClass, method, CreateMethodFromUsageFix.shouldBeAbstractImpl(targetClass), arguments, substitutor, expectedTypes, context);
    }

    private static void doCreate(PsiClass targetClass, PsiMethod method, boolean shouldBeAbstract, List<Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        if ((method = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(method)) == null) {
            return;
        }
        final Project project = targetClass.getProject();
        final PsiFile targetFile = targetClass.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(targetFile);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        CreateFromUsageUtils.setupMethodParameters(method, (TemplateBuilder)builder, context, substitutor, arguments);
        new GuessTypeParameters(JavaPsiFacade.getInstance((Project)project).getElementFactory()).setupTypeElement(method.getReturnTypeElement(), expectedTypes, substitutor, builder, context, targetClass);
        PsiCodeBlock body = method.getBody();
        builder.setEndVariableAfter((PsiElement)(shouldBeAbstract || body == null ? method : body.getLBrace()));
        method = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(method);
        if (method == null) {
            return;
        }
        assert (document != null);
        RangeMarker rangeMarker = document.createRangeMarker(method.getTextRange());
        final Editor newEditor = CreateMethodFromUsageFix.positionCursor(project, targetFile, (PsiElement)method);
        Template template = builder.buildTemplate();
        newEditor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        newEditor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        if (!shouldBeAbstract) {
            CreateMethodFromUsageFix.startTemplate(newEditor, template, project, new TemplateEditingAdapter(){

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                            int offset = newEditor.getCaretModel().getOffset();
                            PsiMethod method = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)(offset - 1), PsiMethod.class, (boolean)false);
                            if (method != null) {
                                try {
                                    CreateFromUsageUtils.setupMethodBody(method);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                                CreateFromUsageUtils.setupEditor(method, newEditor);
                            }
                        }
                    });
                }
            });
        } else {
            CreateMethodFromUsageFix.startTemplate(newEditor, template, project);
        }
    }

    protected boolean shouldBeAbstract(PsiClass targetClass) {
        return CreateMethodFromUsageFix.shouldBeAbstractImpl(targetClass);
    }

    private static boolean shouldBeAbstractImpl(PsiClass targetClass) {
        return targetClass.isInterface();
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression referenceExpression = callExpression.getMethodExpression();
        return CreateFromUsageUtils.isValidMethodReference((PsiReference)referenceExpression, callExpression);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }

    @Nullable
    protected PsiMethodCallExpression getMethodCall() {
        return (PsiMethodCallExpression)this.myMethodCall.getElement();
    }
}

