/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.LineMarkersProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LineMarkersPass
extends ProgressableTextEditorHighlightingPass
implements LineMarkersProcessor,
DumbAware {
    private volatile Collection<LineMarkerInfo> myMarkers;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myUpdateAll;

    public LineMarkersPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document, int startOffset, int endOffset, boolean updateAll) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.<init> must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.<init> must not be null");
        }
        super(project, document, GeneralHighlightingPass.IN_PROGRESS_ICON, GeneralHighlightingPass.PRESENTABLE_NAME, file, false);
        this.myMarkers = Collections.emptyList();
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myUpdateAll = updateAll;
    }

    @Override
    protected void applyInformationWithProgress() {
        try {
            UpdateHighlightersUtil.setLineMarkersToEditor(this.myProject, this.myDocument, this.myStartOffset, this.myEndOffset, this.myMarkers, 4);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    protected void collectInformationWithProgress(ProgressIndicator progress) {
        ArrayList<LineMarkerInfo> lineMarkers = new ArrayList<LineMarkerInfo>();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightLevelUtil.shouldHighlight((PsiElement)psiRoot)) continue;
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, this.myStartOffset, this.myEndOffset);
            if (elements.isEmpty()) {
                elements = Collections.singletonList(psiRoot);
            }
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language, this.myProject);
            this.addLineMarkers(elements, providers, lineMarkers, progress);
            LineMarkersPass.collectLineMarkersForInjected(lineMarkers, elements, this, this.myFile, progress);
        }
        this.myMarkers = lineMarkers;
    }

    public static List<LineMarkerProvider> getMarkerProviders(Language language, Project project) {
        return DumbService.getInstance((Project)project).filterByDumbAwareness((Collection)LineMarkerProviders.INSTANCE.allForLanguage(language));
    }

    @Override
    public void addLineMarkers(@NotNull List<PsiElement> elements, @NotNull List<LineMarkerProvider> providers, @NotNull List<LineMarkerInfo> result, @NotNull ProgressIndicator progress) throws ProcessCanceledException {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.addLineMarkers must not be null");
        }
        if (providers == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.addLineMarkers must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.addLineMarkers must not be null");
        }
        if (progress == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.addLineMarkers must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (PsiElement element : elements) {
            progress.checkCanceled();
            for (LineMarkerProvider provider : providers) {
                LineMarkerInfo info = provider.getLineMarkerInfo(element);
                if (info == null) continue;
                result.add(info);
            }
        }
    }

    public static void collectLineMarkersForInjected(final @NotNull List<LineMarkerInfo> result, @NotNull List<PsiElement> elements, final @NotNull LineMarkersProcessor processor, @NotNull PsiFile file, final @NotNull ProgressIndicator progress) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.collectLineMarkersForInjected must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.collectLineMarkersForInjected must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.collectLineMarkersForInjected must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.collectLineMarkersForInjected must not be null");
        }
        if (progress == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass.collectLineMarkersForInjected must not be null");
        }
        final InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)file.getProject());
        final ArrayList injectedMarkers = new ArrayList();
        for (PsiElement element : elements) {
            InjectedLanguageUtil.enumerate(element, file, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass$1.visit must not be null");
                    }
                    if (places == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPass$1.visit must not be null");
                    }
                    Project project = injectedPsi.getProject();
                    Document document = PsiDocumentManager.getInstance((Project)project).getCachedDocument(injectedPsi);
                    if (!(document instanceof DocumentWindow)) {
                        return;
                    }
                    List<PsiElement> injElements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
                    List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(injectedPsi.getLanguage(), project);
                    processor.addLineMarkers(injElements, providers, injectedMarkers, progress);
                    for (final LineMarkerInfo injectedMarker : injectedMarkers) {
                        GutterIconRenderer gutterRenderer = injectedMarker.createGutterRenderer();
                        TextRange injectedRange = new TextRange(injectedMarker.startOffset, injectedMarker.endOffset);
                        List editables = manager.intersectWithAllEditableFragments(injectedPsi, injectedRange);
                        for (TextRange editable : editables) {
                            TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, editable);
                            Icon icon = gutterRenderer == null ? null : gutterRenderer.getIcon();
                            LineMarkerInfo converted = new LineMarkerInfo(injectedMarker.getElement(), hostRange, icon, injectedMarker.updatePass, (Function)new Function<PsiElement, String>(){

                                public String fun(PsiElement element) {
                                    return injectedMarker.getLineMarkerTooltip();
                                }
                            }, injectedMarker.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
                            result.add(converted);
                        }
                    }
                    injectedMarkers.clear();
                }
            }, false);
        }
    }

    public Collection<LineMarkerInfo> queryLineMarkers() {
        if (this.myFile.getNode() == null) {
            return Collections.emptyList();
        }
        this.collectInformationWithProgress((ProgressIndicator)new EmptyProgressIndicator());
        return this.myMarkers;
    }

    @Override
    public double getProgress() {
        return this.myUpdateAll ? super.getProgress() : -1.0;
    }

    @NotNull
    public static LineMarkerInfo createMethodSeparatorLineMarker(PsiElement startFrom, EditorColorsManager colorsManager) {
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 4, (Function)NullableFunction.NULL, null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LineMarkersPass.createMethodSeparatorLineMarker must not return null");
        }
        return lineMarkerInfo;
    }
}

