/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class DaemonEditorPopup
extends PopupHandler {
    private final PsiFile myPsiFile;

    public DaemonEditorPopup(PsiFile psiFile) {
        this.myPsiFile = psiFile;
    }

    public void invokePopup(final Component comp, final int x, final int y) {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        final JRadioButtonMenuItem errorsFirst = new JRadioButtonMenuItem(EditorBundle.message((String)"errors.panel.go.to.errors.first.radio", (Object[])new Object[0]));
        errorsFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonCodeAnalyzerSettings.getInstance().NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST = errorsFirst.isSelected();
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(errorsFirst);
        final JRadioButtonMenuItem next = new JRadioButtonMenuItem(EditorBundle.message((String)"errors.panel.go.to.next.error.warning.radio", (Object[])new Object[0]));
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DaemonCodeAnalyzerSettings.getInstance().NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST = !next.isSelected();
            }
        });
        popupMenu.add(next);
        ButtonGroup group = new ButtonGroup();
        group.add(errorsFirst);
        group.add(next);
        popupMenu.addSeparator();
        JMenuItem hLevel = new JMenuItem(EditorBundle.message((String)"customize.highlighting.level.menu.item", (Object[])new Object[0]));
        popupMenu.add(hLevel);
        boolean isErrorsFirst = DaemonCodeAnalyzerSettings.getInstance().NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST;
        errorsFirst.setSelected(isErrorsFirst);
        next.setSelected(!isErrorsFirst);
        hLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiFile psiFile = DaemonEditorPopup.this.myPsiFile;
                if (psiFile == null) {
                    return;
                }
                HectorComponent component = new HectorComponent(psiFile);
                Dimension dimension = component.getPreferredSize();
                Point point = new Point(x, y);
                component.showComponent(new RelativePoint(comp, new Point(point.x - dimension.width, point.y)));
            }
        });
        PsiFile file = this.myPsiFile;
        if (file != null && DaemonCodeAnalyzer.getInstance((Project)this.myPsiFile.getProject()).isHighlightingAvailable(file)) {
            popupMenu.show(comp, x, y);
        }
    }
}

