/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    public static final Key<Condition<String>> NAME_FILTER = Key.create((String)"NAME_FILTER");
    private boolean myStatic = false;
    private final Set<Object> myResultNames = new THashSet();
    private final List<CompletionElement> myResults;
    private final PsiElement myElement;
    private final PsiElement myScope;
    private CodeInsightSettings mySettings = null;
    private final ElementFilter myFilter;
    private boolean myMembersFlag = false;
    private PsiType myQualifierType = null;
    private PsiClass myQualifierClass = null;
    private final Condition<String> myMatcher;
    private final boolean myCheckAccess;

    public JavaCompletionProcessor(PsiElement element, ElementFilter filter, boolean checkAccess, @Nullable Condition<String> nameCondition) {
        PsiElement elementParent;
        this.myCheckAccess = checkAccess;
        this.mySettings = CodeInsightSettings.getInstance();
        this.myResults = new ArrayList<CompletionElement>();
        this.myElement = element;
        this.myMatcher = nameCondition;
        this.myFilter = filter;
        PsiElement scope = element;
        if (JavaResolveUtil.isInJavaDoc(this.myElement)) {
            this.myMembersFlag = true;
        }
        while (scope != null && !(scope instanceof PsiFile) && !(scope instanceof PsiClass)) {
            scope = scope.getContext();
        }
        this.myScope = scope;
        if (!(element.getContainingFile() instanceof PsiJavaFile)) {
            this.myMembersFlag = true;
        }
        if ((elementParent = element.getContext()) instanceof PsiReferenceExpression) {
            PsiExpression qualifier = ((PsiReferenceExpression)elementParent).getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression) {
                this.myQualifierClass = JavaResolveUtil.getContextClass(this.myElement);
                if (this.myQualifierClass != null) {
                    this.myQualifierType = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).getElementFactory().createType(this.myQualifierClass);
                }
            } else if (qualifier != null) {
                PsiElement target;
                this.myQualifierType = qualifier.getType();
                this.myQualifierClass = PsiUtil.resolveClassInType((PsiType)this.myQualifierType);
                if (this.myQualifierType == null && qualifier instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass) {
                    this.myQualifierClass = (PsiClass)target;
                }
            }
        }
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStatic = true;
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL) {
            this.myMembersFlag = true;
        }
    }

    public boolean execute(PsiElement element, ResolveState state) {
        String name;
        if (!(element instanceof PsiClass) && element instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
            if (this.myStatic ? !modifierListOwner.hasModifierProperty("static") : !this.mySettings.SHOW_STATIC_AFTER_INSTANCE && modifierListOwner.hasModifierProperty("static") && !this.myMembersFlag) {
                return true;
            }
        }
        PsiElement elementParent = this.myElement.getParent();
        if (element instanceof PsiPackage && this.myScope instanceof PsiClass && (!(elementParent instanceof PsiQualifiedReference) || ((PsiQualifiedReference)elementParent).getQualifier() == null)) {
            return true;
        }
        if (this.myFilter.isClassAcceptable(element.getClass()) && this.myFilter.isAcceptable((Object)new CandidateInfo(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY)), this.myElement) && StringUtil.isNotEmpty((String)(name = PsiUtil.getName((PsiElement)element))) && (this.myMatcher == null || this.myMatcher.value((Object)name)) && this.isAccessible(element)) {
            this.add(new CompletionElement(this.myQualifierType, element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), this.myQualifierClass));
        }
        return true;
    }

    @Nullable
    public PsiType getQualifierType() {
        return this.myQualifierType;
    }

    private boolean isAccessible(PsiElement element) {
        if (!this.myCheckAccess) {
            return true;
        }
        if (!(element instanceof PsiMember)) {
            return true;
        }
        return JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper().isAccessible((PsiMember)element, this.myElement, this.myQualifierClass);
    }

    private void add(CompletionElement element) {
        if (this.myResultNames.add(element.getUniqueId())) {
            this.myResults.add(element);
        }
    }

    public void setCompletionElements(@NotNull Object[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/scope/JavaCompletionProcessor.setCompletionElements must not be null");
        }
        for (Object element : elements) {
            this.myResults.add(new CompletionElement(null, element, PsiSubstitutor.EMPTY, this.myQualifierClass));
        }
    }

    public Set<CompletionElement> getResults() {
        return new THashSet(this.myResults);
    }

    public void clear() {
        this.myResults.clear();
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclaractionKind kind) {
        switch (kind) {
            case CLASS: {
                return this.myFilter.isClassAcceptable(PsiClass.class);
            }
            case FIELD: {
                return this.myFilter.isClassAcceptable(PsiField.class);
            }
            case METHOD: {
                return this.myFilter.isClassAcceptable(PsiMethod.class);
            }
            case PACKAGE: {
                return this.myFilter.isClassAcceptable(PsiPackage.class);
            }
            case VARIABLE: {
                return this.myFilter.isClassAcceptable(PsiVariable.class);
            }
            case ENUM_CONST: {
                return this.myFilter.isClassAcceptable(PsiEnumConstant.class);
            }
        }
        return false;
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        if (hintKey == NAME_FILTER) {
            return (T)this.myMatcher;
        }
        return super.getHint(hintKey);
    }
}

