/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;

public class FontEditorPreview
implements PreviewPanel {
    private final EditorEx myEditor;
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public FontEditorPreview(ColorAndFontOptions options) {
        this.myOptions = options;
        String text = FontEditorPreview.getIDEDemoText();
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(text, 10, 3, -1, this.myOptions);
        FontEditorPreview.installTrafficLights(this.myEditor);
    }

    public static String getIDEDemoText() {
        String name = ApplicationNamesInfo.getInstance().getFullProductName();
        String language = name.contains("RubyMine") ? "Ruby" : "Java";
        return name + " is a full-featured " + language + " IDE\n" + "with a high level of usability and outstanding\n" + "advanced code editing and refactoring support.\n";
    }

    static void installTrafficLights(EditorEx editor) {
        TrafficLightRenderer renderer = new TrafficLightRenderer(null, null, null, null){

            @Override
            protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(boolean fillErrorsCount) {
                TrafficLightRenderer.DaemonCodeAnalyzerStatus status = new TrafficLightRenderer.DaemonCodeAnalyzerStatus();
                status.errorAnalyzingFinished = true;
                status.passStati = new ArrayList<TrafficLightRenderer.DaemonCodeAnalyzerStatus.PassStatus>();
                status.errorCount = new int[]{1, 2};
                return status;
            }
        };
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeRenderer(renderer);
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
    }

    static Editor createPreviewEditor(String text, int column, int line, int selectedLine, ColorAndFontOptions options) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)text);
        EditorEx editor = (EditorEx)editorFactory.createViewer(editorDocument);
        editor.setColorsScheme(options.getSelectedScheme());
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(true);
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        LogicalPosition pos = new LogicalPosition(line, column);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (selectedLine >= 0) {
            editor.getSelectionModel().setSelection(editorDocument.getLineStartOffset(selectedLine), editorDocument.getLineEndOffset(selectedLine));
        }
        return editor;
    }

    @Override
    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme = this.myOptions.getSelectedScheme();
        this.myEditor.setColorsScheme(scheme);
        this.myEditor.reinitSettings();
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
    }
}

