/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestClassesFilter;
import com.intellij.idea.Bombed;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestRunnerUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCaseLoader {
    private final List<Class> myClassList = new ArrayList<Class>();
    private final TestClassesFilter myTestClassesFilter;
    private final String myTestGroupName;
    private final Set<String> blockedTests = new HashSet<String>();
    private static final List<String> ourRanklist = TestCaseLoader.getTeamCityRankList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestCaseLoader(String classFilterName) {
        InputStream excludedStream = this.getClass().getClassLoader().getResourceAsStream(classFilterName);
        if (excludedStream != null) {
            try {
                this.myTestClassesFilter = TestClassesFilter.createOn(new InputStreamReader(excludedStream));
            }
            finally {
                try {
                    excludedStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.myTestGroupName = System.getProperty("idea.test.group");
        } else {
            String patterns = System.getProperty("idea.test.patterns");
            this.myTestClassesFilter = patterns != null ? new TestClassesFilter(StringUtil.split((String)patterns, (String)";")) : TestClassesFilter.EMPTY_CLASSES_FILTER;
            this.myTestGroupName = "";
        }
        try {
            if (Comparing.equal((String)System.getProperty("idea.fast.only"), (String)"true")) {
                String testName;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("tests/slowTests.txt")));
                while ((testName = reader.readLine()) != null) {
                    this.blockedTests.add(testName);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Using test group: [" + (this.myTestGroupName == null ? "" : this.myTestGroupName) + "]");
    }

    void addClassIfTestCase(Class testCaseClass) {
        if (this.shouldAddTestCase(testCaseClass)) {
            this.myClassList.add(testCaseClass);
        }
    }

    private boolean shouldAddTestCase(Class testCaseClass) {
        if ((testCaseClass.getModifiers() & 0x400) != 0) {
            return false;
        }
        if (this.shouldExcludeTestClass(testCaseClass)) {
            return false;
        }
        if (TestCase.class.isAssignableFrom(testCaseClass) || TestSuite.class.isAssignableFrom(testCaseClass)) {
            return true;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (Test.class.isAssignableFrom(suiteMethod.getReturnType()) && (suiteMethod.getModifiers() & 8) != 0) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return TestRunnerUtil.isJUnit4TestClass(testCaseClass);
    }

    private boolean shouldExcludeTestClass(Class testCaseClass) {
        return !this.myTestClassesFilter.matches(testCaseClass.getName(), this.myTestGroupName) || TestCaseLoader.isBombed(testCaseClass) || this.blockedTests.contains(testCaseClass.getName());
    }

    public static boolean isBombed(Method method) {
        Bombed bombedAnnotation = method.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        if (PlatformTestUtil.isRotten(bombedAnnotation)) {
            String message = "Disarm the stale bomb for '" + method + "' in class '" + method.getDeclaringClass() + "'";
            System.err.println(message);
        }
        return !PlatformTestUtil.bombExplodes(bombedAnnotation);
    }

    public static boolean isBombed(Class<?> testCaseClass) {
        Bombed bombedAnnotation = testCaseClass.getAnnotation(Bombed.class);
        if (bombedAnnotation == null) {
            return false;
        }
        if (PlatformTestUtil.isRotten(bombedAnnotation)) {
            String message = "Disarm the stale bomb for '" + testCaseClass + "'";
            System.err.println(message);
        }
        return !PlatformTestUtil.bombExplodes(bombedAnnotation);
    }

    public void loadTestCases(Collection<String> classNamesIterator) {
        for (String className : classNamesIterator) {
            try {
                Class<?> candidateClass = Class.forName(className);
                this.addClassIfTestCase(candidateClass);
            }
            catch (UnsatisfiedLinkError e) {
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.err.println("Cannot load class: " + className + " " + e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
                System.err.println("Cannot load class that " + className + " is dependant on");
            }
            catch (ExceptionInInitializerError e) {
                e.printStackTrace();
                e.getException().printStackTrace();
                System.err.println("Cannot load class: " + className + " " + e.getException().getMessage());
            }
        }
    }

    private static List<String> getTeamCityRankList() {
        String filepath = System.getProperty("teamcity.tests.recentlyFailedTests.file", null);
        if (filepath == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            String classname;
            BufferedReader reader = new BufferedReader(new FileReader(filepath));
            while ((classname = reader.readLine()) != null) {
                result.add(classname);
            }
            return result;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private static int getRank(Class aClass) {
        String name = aClass.getName();
        if (ourRanklist.contains(name)) {
            return ourRanklist.indexOf(name);
        }
        return Integer.MAX_VALUE;
    }

    public List<Class> getClasses() {
        ArrayList<Class> result = new ArrayList<Class>(this.myClassList);
        if (!ourRanklist.isEmpty()) {
            Collections.sort(result, new Comparator<Class>(){

                @Override
                public int compare(Class o1, Class o2) {
                    return TestCaseLoader.getRank(o1) - TestCaseLoader.getRank(o2);
                }
            });
        }
        return result;
    }
}

