/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaitNotInSynchronizedContextInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("WaitWhileNotSynced" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection.getID must not return null");
        }
        return "WaitWhileNotSynced";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("wait.not.in.synchronized.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text;
        if (infos.length > 0) {
            PsiElement element = (PsiElement)infos[0];
            text = element.getText();
        } else {
            text = "this";
        }
        String string = InspectionGadgetsBundle.message("wait.not.in.synchronized.context.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitNotInSynchronizedContextVisitor();
    }

    private static class WaitNotInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private WaitNotInSynchronizedContextVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection$WaitNotInSynchronizedContextVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"wait".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            String qualifiedName = aClass.getQualifiedName();
            if (!qualifiedName.equals("java.lang.Object")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                if (WaitNotInSynchronizedContextVisitor.isSynchronizedOnThis((PsiElement)expression)) {
                    return;
                }
                this.registerError((PsiElement)expression, new Object[0]);
            } else if (qualifier instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (WaitNotInSynchronizedContextVisitor.isSynchronizedOn((PsiElement)expression, target)) {
                    return;
                }
                this.registerError((PsiElement)expression, qualifier);
            }
        }

        private static boolean isSynchronizedOn(@NotNull PsiElement element, @Nullable PsiElement target) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection$WaitNotInSynchronizedContextVisitor.isSynchronizedOn must not be null");
            }
            if (target == null) {
                return false;
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, PsiSynchronizedStatement.class);
            if (context == null) {
                return false;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)context;
            PsiExpression lockExpression = synchronizedStatement.getLockExpression();
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            PsiElement lockTarget = referenceExpression.resolve();
            return target.equals(lockTarget) || WaitNotInSynchronizedContextVisitor.isSynchronizedOn((PsiElement)synchronizedStatement, target);
        }

        private static boolean isSynchronizedOnThis(@NotNull PsiElement element) {
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/WaitNotInSynchronizedContextInspection$WaitNotInSynchronizedContextVisitor.isSynchronizedOnThis must not be null");
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiSynchronizedStatement.class});
            if (context instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)context;
                PsiExpression lockExpression = synchronizedStatement.getLockExpression();
                return lockExpression instanceof PsiThisExpression || WaitNotInSynchronizedContextVisitor.isSynchronizedOnThis((PsiElement)synchronizedStatement);
            }
            return context instanceof PsiMethod && (method = (PsiMethod)context).hasModifierProperty("synchronized");
        }
    }
}

