/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedFieldAccessInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unqualified.field.access.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnqualifiedFieldAccessInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedFieldAccessVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unqualified.field.access.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnqualifiedFieldAccessInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnqualifiedFieldAccessFix();
    }

    private static class UnqualifiedFieldAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnqualifiedFieldAccessInspection$UnqualifiedFieldAccessVisitor.visitReferenceExpression must not be null");
            }
            super.visitReferenceExpression(expression);
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiReferenceExpression || parent instanceof PsiCallExpression) {
                return;
            }
            PsiReferenceParameterList parameterList = expression.getParameterList();
            if (parameterList == null) {
                return;
            }
            if (parameterList.getTypeArguments().length > 0) {
                return;
            }
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (qualifierExpression != null) {
                return;
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class UnqualifiedFieldAccessFix
    extends InspectionGadgetsFix {
        private UnqualifiedFieldAccessFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("add.this.qualifier.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnqualifiedFieldAccessInspection$UnqualifiedFieldAccessFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiClass parentClass;
            PsiReferenceExpression expression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiField field = (PsiField)expression.resolve();
            if (field == null) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            String newExpression = !containingClass.equals(parentClass = ClassUtils.getContainingClass((PsiElement)expression)) ? containingClass.getQualifiedName() + ".this." + expression.getText() : "this." + expression.getText();
            UnqualifiedFieldAccessFix.replaceExpressionAndShorten((PsiExpression)expression, newExpression);
        }
    }
}

