/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class CStyleArrayDeclarationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("c.style.array.declaration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/CStyleArrayDeclarationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("c.style.array.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/CStyleArrayDeclarationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CStyleArrayDeclarationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CStyleArrayDeclarationVisitor();
    }

    private static class CStyleArrayDeclarationVisitor
    extends BaseInspectionVisitor {
        private CStyleArrayDeclarationVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable var) {
            if (var == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/CStyleArrayDeclarationInspection$CStyleArrayDeclarationVisitor.visitVariable must not be null");
            }
            super.visitVariable(var);
            PsiType declaredType = var.getType();
            if (declaredType.getArrayDimensions() == 0) {
                return;
            }
            PsiTypeElement typeElement = var.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType elementType = typeElement.getType();
            if (elementType.equals(declaredType)) {
                return;
            }
            this.registerVariableError(var, new Object[0]);
        }
    }

    private static class CStyleArrayDeclarationFix
    extends InspectionGadgetsFix {
        private CStyleArrayDeclarationFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("c.style.array.declaration.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/CStyleArrayDeclarationInspection$CStyleArrayDeclarationFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement nameElement = descriptor.getPsiElement();
            PsiVariable var = (PsiVariable)nameElement.getParent();
            assert (var != null);
            var.normalizeDeclaration();
        }
    }
}

