/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SerializableWithUnconstructableAncestorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SerializableClassWithUnconstructableAncestor" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection.getID must not return null");
        }
        return "SerializableClassWithUnconstructableAncestor";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.with.unconstructable.ancestor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass ancestor = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("serializable.with.unconstructable.ancestor.problem.descriptor", ancestor.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableWithUnconstructableAncestorVisitor();
    }

    private static class SerializableWithUnconstructableAncestorVisitor
    extends BaseInspectionVisitor {
        private SerializableWithUnconstructableAncestorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection$SerializableWithUnconstructableAncestorVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            PsiClass ancestor = aClass.getSuperClass();
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>(16);
            while (ancestor != null && SerializationUtils.isSerializable(ancestor)) {
                if (visitedClasses.add(ancestor = ancestor.getSuperClass())) continue;
                return;
            }
            if (ancestor == null) {
                return;
            }
            if (SerializableWithUnconstructableAncestorVisitor.classHasNoArgConstructor(ancestor)) {
                return;
            }
            this.registerClassError(aClass, ancestor);
        }

        private static boolean classHasNoArgConstructor(PsiClass ancestor) {
            PsiMethod[] methods;
            boolean hasConstructor = false;
            boolean hasNoArgConstructor = false;
            for (PsiMethod method : methods = ancestor.getMethods()) {
                if (!method.isConstructor()) continue;
                hasConstructor = true;
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 0 || !method.hasModifierProperty("public") && !method.hasModifierProperty("protected")) continue;
                hasNoArgConstructor = true;
            }
            return hasNoArgConstructor || !hasConstructor;
        }
    }
}

