/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddSerialVersionUIDFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspection;
import org.jetbrains.annotations.NotNull;

public class SerializableHasSerialVersionUIDFieldInspection
extends SerializableInspection {
    @NotNull
    public String getID() {
        if ("serial" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableHasSerialVersionUIDFieldInspection.getID must not return null");
        }
        return "serial";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.class.without.serialversionuid.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableHasSerialVersionUIDFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serializable.class.without.serialversionuid.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerializableHasSerialVersionUIDFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSerialVersionUIDFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableHasSerialVersionUIDFieldVisitor();
    }

    private class SerializableHasSerialVersionUIDFieldVisitor
    extends BaseInspectionVisitor {
        private SerializableHasSerialVersionUIDFieldVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/SerializableHasSerialVersionUIDFieldInspection$SerializableHasSerialVersionUIDFieldVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            PsiField serialVersionUIDField = aClass.findFieldByName("serialVersionUID", false);
            if (serialVersionUIDField != null) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (SerializableHasSerialVersionUIDFieldInspection.this.isIgnoredSubclass(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

