/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class ReadObjectInitializationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("InstanceVariableMayNotBeInitializedByReadObject" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ReadObjectInitializationInspection.getID must not return null");
        }
        return "InstanceVariableMayNotBeInitializedByReadObject";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("readobject.initialization.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ReadObjectInitializationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("readobject.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ReadObjectInitializationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectInitializationVisitor();
    }

    private static class ReadObjectInitializationVisitor
    extends BaseInspectionVisitor {
        private ReadObjectInitializationVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/ReadObjectInitializationInspection$ReadObjectInitializationVisitor.visitMethod must not be null");
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (!SerializationUtils.isReadObject(method)) {
                return;
            }
            boolean defaultReadObjectCalled = ControlFlowUtils.elementContainsCallToMethod((PsiElement)method, "java.io.ObjectInputStream", PsiType.VOID, "defaultReadObject", new PsiType[0]);
            PsiField[] fields = aClass.getFields();
            if (defaultReadObjectCalled) {
                for (PsiField field : fields) {
                    if (!field.hasModifierProperty("transient") || ReadObjectInitializationVisitor.isFieldInitialized(field, method)) continue;
                    this.registerFieldError(field, new Object[0]);
                }
            } else {
                for (PsiField field : fields) {
                    if (ReadObjectInitializationVisitor.isFieldInitialized(field, method)) continue;
                    this.registerFieldError(field, new Object[0]);
                }
            }
        }

        public static boolean isFieldInitialized(@NotNull PsiField field, @NotNull PsiMethod method) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/ReadObjectInitializationInspection$ReadObjectInitializationVisitor.isFieldInitialized must not be null");
            }
            if (method == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/serialization/ReadObjectInitializationInspection$ReadObjectInitializationVisitor.isFieldInitialized must not be null");
            }
            if (field.hasModifierProperty("static")) {
                return true;
            }
            if (field.hasModifierProperty("final") && field.getInitializer() != null) {
                return true;
            }
            return InitializationUtils.methodAssignsVariableOrFails(method, (PsiVariable)field);
        }
    }
}

