/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class InstanceOfUtils {
    private InstanceOfUtils() {
    }

    public static PsiInstanceOfExpression getConflictingInstanceof(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InstanceOfUtils.getConflictingInstanceof must not be null");
        }
        PsiType castType = expression.getType();
        PsiExpression operand = expression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
        InstanceofChecker checker = new InstanceofChecker(referenceExpression, castType, false);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiBinaryExpression.class, PsiIfStatement.class, PsiConditionalExpression.class});
        while (parent != null) {
            parent.accept((PsiElementVisitor)checker);
            if (checker.hasAgreeingInstanceof()) {
                return null;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiBinaryExpression.class, PsiIfStatement.class, PsiConditionalExpression.class});
        }
        if (checker.hasAgreeingInstanceof()) {
            return null;
        }
        return checker.getConflictingInstanceof();
    }

    public static boolean hasAgreeingInstanceof(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/InstanceOfUtils.hasAgreeingInstanceof must not be null");
        }
        PsiType castType = expression.getType();
        PsiExpression operand = expression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
        InstanceofChecker checker = new InstanceofChecker(referenceExpression, castType, false);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiBinaryExpression.class, PsiIfStatement.class, PsiConditionalExpression.class});
        while (parent != null) {
            parent.accept((PsiElementVisitor)checker);
            if (checker.hasAgreeingInstanceof()) {
                return true;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiBinaryExpression.class, PsiIfStatement.class, PsiConditionalExpression.class});
        }
        return false;
    }

    private static class InstanceofChecker
    extends JavaElementVisitor {
        private final PsiReferenceExpression referenceExpression;
        private final PsiType castType;
        private final boolean strict;
        private boolean inElse = false;
        private PsiInstanceOfExpression conflictingInstanceof = null;
        private boolean agreeingInstanceof = false;

        InstanceofChecker(PsiReferenceExpression referenceExpression, PsiType castType, boolean strict) {
            this.referenceExpression = referenceExpression;
            this.castType = castType;
            this.strict = strict;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitExpression((PsiExpression)expression);
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (tokenType == JavaTokenType.ANDAND) {
                this.checkExpression(expression.getLOperand());
                if (this.agreeingInstanceof) {
                    return;
                }
                this.checkExpression(expression.getROperand());
                if (this.agreeingInstanceof) {
                    return;
                }
                if (!this.inElse && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            } else if (tokenType == JavaTokenType.OROR) {
                this.checkExpression(expression.getLOperand());
                this.checkExpression(expression.getROperand());
                if (this.inElse && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            }
        }

        public void visitIfStatement(PsiIfStatement ifStatement) {
            PsiBlockStatement blockStatement;
            PsiStatement thenBranch;
            PsiBlockStatement blockStatement2;
            PsiStatement branch = ifStatement.getElseBranch();
            boolean bl = this.inElse = branch != null && PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)this.referenceExpression, (boolean)true);
            if (this.inElse ? branch instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, (PsiElement)(blockStatement2 = (PsiBlockStatement)branch)) : (thenBranch = ifStatement.getThenBranch()) instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, (PsiElement)(blockStatement = (PsiBlockStatement)thenBranch))) {
                return;
            }
            PsiExpression condition = ifStatement.getCondition();
            if ((condition = PsiUtil.deparenthesizeExpression((PsiExpression)condition)) instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                this.visitBinaryExpression(binaryExpression);
            } else {
                this.checkExpression(condition);
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            PsiExpression elseExpression = expression.getElseExpression();
            this.inElse = elseExpression != null && PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)this.referenceExpression, (boolean)true);
            PsiExpression condition = expression.getCondition();
            if ((condition = PsiUtil.deparenthesizeExpression((PsiExpression)condition)) instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                this.visitBinaryExpression(binaryExpression);
            } else {
                this.checkExpression(condition);
            }
        }

        private void checkExpression(PsiExpression expression) {
            expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression);
            if (this.inElse) {
                if (expression instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                    IElementType tokenType = prefixExpression.getOperationTokenType();
                    if (tokenType != JavaTokenType.EXCL) {
                        return;
                    }
                    expression = PsiUtil.deparenthesizeExpression((PsiExpression)prefixExpression.getOperand());
                    this.checkInstanceOfExpression(expression);
                }
            } else {
                this.checkInstanceOfExpression(expression);
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                this.visitBinaryExpression(binaryExpression);
            }
        }

        private void checkInstanceOfExpression(PsiExpression expression) {
            if (!(expression instanceof PsiInstanceOfExpression)) {
                return;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
            if (this.isAgreeing(instanceOfExpression)) {
                this.agreeingInstanceof = true;
            } else if (this.isConflicting(instanceOfExpression)) {
                this.conflictingInstanceof = instanceOfExpression;
            }
        }

        private boolean isConflicting(PsiInstanceOfExpression expression) {
            PsiExpression conditionOperand = expression.getOperand();
            if (!EquivalenceChecker.expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type = typeElement.getType();
            if (this.strict) {
                return !this.castType.equals(type);
            }
            return !this.castType.isAssignableFrom(type);
        }

        private boolean isAgreeing(PsiInstanceOfExpression expression) {
            PsiExpression conditionOperand = expression.getOperand();
            if (!EquivalenceChecker.expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type = typeElement.getType();
            if (this.strict) {
                return this.castType.equals(type);
            }
            return this.castType.isAssignableFrom(type);
        }

        public boolean hasAgreeingInstanceof() {
            return this.agreeingInstanceof;
        }

        public PsiInstanceOfExpression getConflictingInstanceof() {
            return this.conflictingInstanceof;
        }
    }
}

