/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LengthOneStringsInConcatenationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("length.one.strings.in.concatenation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("SingleCharacterStringConcatenation" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection.getID must not return null");
        }
        return "SingleCharacterStringConcatenation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        String escapedString = StringUtil.escapeStringCharacters((String)string);
        String string2 = InspectionGadgetsBundle.message("length.one.strings.in.concatenation.problem.descriptor", escapedString);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection.buildErrorString must not return null");
        }
        return string2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LengthOneStringsInConcatenationVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceStringsWithCharsFix();
    }

    private static class LengthOneStringsInConcatenationVisitor
    extends BaseInspectionVisitor {
        private LengthOneStringsInConcatenationVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection$LengthOneStringsInConcatenationVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            String value = (String)expression.getValue();
            if (value == null || value.length() != 1) {
                return;
            }
            if (!LengthOneStringsInConcatenationVisitor.isArgumentOfConcatenation((PsiExpression)expression) && !LengthOneStringsInConcatenationVisitor.isArgumentOfStringAppend((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, value);
        }

        private static boolean isArgumentOfConcatenation(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExp = (PsiBinaryExpression)parent;
            PsiJavaToken sign = binaryExp.getOperationSign();
            if (!JavaTokenType.PLUS.equals(sign.getTokenType())) {
                return false;
            }
            PsiExpression lhs = binaryExp.getLOperand();
            PsiExpression sibling = lhs.equals(expression) ? binaryExp.getROperand() : lhs;
            if (sibling == null) {
                return false;
            }
            PsiType siblingType = sibling.getType();
            return TypeUtils.isJavaLangString(siblingType);
        }

        static boolean isArgumentOfStringAppend(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandparent = parent.getParent();
            if (!(grandparent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)grandparent;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"append".equals(name) && !"insert".equals(name)) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            String className = methodClass.getQualifiedName();
            return "java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className);
        }
    }

    private static class ReplaceStringsWithCharsFix
    extends InspectionGadgetsFix {
        private ReplaceStringsWithCharsFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("length.one.strings.in.concatenation.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection$ReplaceStringsWithCharsFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            int length;
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            String text = expression.getText();
            String character = text.substring(1, (length = text.length()) - 1);
            String charLiteral = "'".equals(character) ? "'\\''" : '\'' + character + '\'';
            ReplaceStringsWithCharsFix.replaceExpression(expression, charLiteral);
        }
    }
}

