/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class CollectionsMustHaveInitialCapacityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CollectionWithoutInitialCapacity" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection.getID must not return null");
        }
        return "CollectionWithoutInitialCapacity";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collections.must.have.initial.capacity.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("collections.must.have.initial.capacity.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionInitialCapacityVisitor();
    }

    private static class CollectionInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private CollectionInitialCapacityVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/CollectionsMustHaveInitialCapacityInspection$CollectionInitialCapacityVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!CollectionUtils.isCollectionWithInitialCapacity(type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] parameters = argumentList.getExpressions();
            if (parameters.length != 0) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

