/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceConstantFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ZeroLengthArrayInitializationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ZeroLengthArrayAllocation" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/memory/ZeroLengthArrayInitializationInspection.getID must not return null");
        }
        return "ZeroLengthArrayAllocation";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.allocation.zero.length.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/memory/ZeroLengthArrayInitializationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.allocation.zero.length.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/memory/ZeroLengthArrayInitializationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ZeroLengthArrayInitializationVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceConstantFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static class ZeroLengthArrayInitializationVisitor
    extends BaseInspectionVisitor {
        private ZeroLengthArrayInitializationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/memory/ZeroLengthArrayInitializationInspection$ZeroLengthArrayInitializationVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            if (!ExpressionUtils.isZeroLengthArrayConstruction((PsiExpression)expression)) {
                return;
            }
            if (ZeroLengthArrayInitializationVisitor.isDeclaredConstant((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiExpression[] initializers = expression.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (expression.getParent() instanceof PsiNewExpression) {
                return;
            }
            if (ZeroLengthArrayInitializationVisitor.isDeclaredConstant((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isDeclaredConstant(PsiExpression expression) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
            if (field == null) {
                return false;
            }
            return field.hasModifierProperty("static") && field.hasModifierProperty("final");
        }
    }
}

